/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.disk.DiskJobWriteBlock;
import org.johnnei.javatorrent.internal.network.ByteInputStream;
import org.johnnei.javatorrent.test.StubEntity;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DiskJobWriteBlockTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private CountDownLatch countDownLatch;

    @Before
    public void setUp() {
        this.countDownLatch = new CountDownLatch(1);
    }

    @Test
    public void testWriteBlock() throws Exception {
        byte[] writtenBytes;
        byte[] bytes = "Hello world write!".getBytes(Charset.forName("UTF-8"));
        File testFile = this.tempFolder.newFile();
        FileInfo fileInfo = new FileInfo(18L, 0L, testFile, 1);
        AbstractFileSet filesStub = StubEntity.stubAFiles(1, fileInfo);
        Piece piece = new Piece(filesStub, new byte[20], 0, 18, 18);
        DiskJobWriteBlock cut = new DiskJobWriteBlock(piece, 0, bytes, x -> this.countDownLatch.countDown());
        cut.process();
        try (ByteInputStream inputStream = new ByteInputStream((InputStream)new FileInputStream(testFile));){
            writtenBytes = inputStream.readByteArray(18);
        }
        Assert.assertTrue((boolean)this.countDownLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertArrayEquals((String)"Incorrect output", (byte[])bytes, (byte[])writtenBytes);
        Assert.assertEquals((String)"Incorrect priority", (long)0L, (long)cut.getPriority());
        Assert.assertEquals((String)"Incorrect piece", (Object)piece, (Object)cut.getPiece());
        Assert.assertEquals((String)"Incorrect block", (long)0L, (long)cut.getBlockIndex());
    }
}

