/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoopingRunnableTest {
    private CountDownLatch countDownLatch;

    @Before
    public void setUp() {
        this.countDownLatch = new CountDownLatch(1);
    }

    @Test
    public void testStoppable() throws Exception {
        LoopingRunnable runnable = new LoopingRunnable(() -> this.countDownLatch.countDown());
        Thread thread = new Thread((Runnable)runnable);
        thread.setDaemon(true);
        thread.start();
        if (!this.countDownLatch.await(5L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Runnable didn't run at least once in 5 seconds");
        }
        runnable.stop();
        thread.join(5000L);
        if (thread.isAlive()) {
            Assert.fail((String)"Thread didn't stop");
        }
    }
}

