/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network.socket;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.internal.network.socket.TcpSocket;
import org.johnnei.javatorrent.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public class TcpSocketTest
extends EasyMockSupport {
    private TcpSocket cut;
    private Socket socketMock;

    @Before
    public void setUp() {
        this.socketMock = (Socket)this.createMock(Socket.class);
        this.cut = new TcpSocket(this.socketMock);
    }

    @Test
    public void testClose() throws Exception {
        this.socketMock.close();
        this.replayAll();
        this.cut.close();
        this.verifyAll();
    }

    @Test
    public void testGetStreams() throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EasyMock.expect((Object)this.socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)this.socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        Assert.assertEquals((String)"Incorrect inputstream", (Object)inputStream, (Object)this.cut.getInputStream());
        Assert.assertEquals((String)"Incorrect outputstream", (Object)outputStream, (Object)this.cut.getOutputStream());
        this.verifyAll();
    }

    @Test
    public void testIsInputShutdown() {
        EasyMock.expect((Object)this.socketMock.isInputShutdown()).andReturn((Object)true);
        this.replayAll();
        Assert.assertTrue((boolean)this.cut.isInputShutdown());
        this.verifyAll();
    }

    @Test
    public void testDefaultConstructor() {
        TcpSocket socket = new TcpSocket();
        Assert.assertNotNull((Object)Whitebox.getInternalState((Object)socket, Socket.class));
    }

    @Test
    public void testConnect() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getLocalHost(), 27960);
        this.socketMock.connect((SocketAddress)EasyMock.same((Object)socketAddress), EasyMock.eq((int)10000));
        this.replayAll();
        this.cut.connect(socketAddress);
        this.verifyAll();
    }

    @Test
    public void testEqualsAndHashcode() throws Exception {
        Socket mockOne = (Socket)this.createMock(Socket.class);
        Socket mockTwo = (Socket)this.createMock(Socket.class);
        TcpSocket socketOne = new TcpSocket(mockOne);
        TcpSocket socketTwo = new TcpSocket(mockOne);
        TcpSocket socketThree = new TcpSocket(mockTwo);
        EasyMock.expect((Object)mockOne.getRemoteSocketAddress()).andReturn((Object)new InetSocketAddress(InetAddress.getLocalHost(), 27960));
        this.replayAll();
        TestUtils.assertEqualityMethods(socketOne, socketTwo, socketThree);
        Assert.assertTrue((String)"Incorrect toString start", (boolean)socketOne.toString().startsWith("TcpSocket["));
        this.verifyAll();
    }

    @Test
    public void testFlush() throws Exception {
        OutputStream outputStreamMock = (OutputStream)this.createMock(OutputStream.class);
        EasyMock.expect((Object)this.socketMock.getOutputStream()).andReturn((Object)outputStreamMock);
        outputStreamMock.flush();
        this.replayAll();
        this.cut.flush();
        this.verifyAll();
    }

    @Test
    public void testIsOutputShutdown() {
        EasyMock.expect((Object)this.socketMock.isOutputShutdown()).andReturn((Object)true);
        this.replayAll();
        Assert.assertTrue((boolean)this.cut.isOutputShutdown());
        this.verifyAll();
    }

    @Test
    public void testIsClosed() {
        EasyMock.expect((Object)this.socketMock.isClosed()).andReturn((Object)false);
        EasyMock.expect((Object)this.socketMock.isConnected()).andReturn((Object)false);
        EasyMock.expect((Object)this.socketMock.isClosed()).andReturn((Object)true);
        EasyMock.expect((Object)this.socketMock.isClosed()).andReturn((Object)false);
        EasyMock.expect((Object)this.socketMock.isConnected()).andReturn((Object)true);
        this.replayAll();
        Assert.assertTrue((boolean)this.cut.isClosed());
        Assert.assertTrue((boolean)this.cut.isClosed());
        Assert.assertFalse((boolean)this.cut.isClosed());
        this.verifyAll();
    }
}

