/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent.peer;

import java.util.ArrayList;
import org.johnnei.javatorrent.internal.torrent.peer.Client;
import org.johnnei.javatorrent.internal.torrent.peer.Job;
import org.junit.Assert;
import org.junit.Test;

public class ClientTest {
    @Test
    public void testChoke() {
        Client cut = new Client();
        cut.choke();
        Assert.assertTrue((String)"Client is unchoked after choke call", (boolean)cut.isChoked());
        cut.unchoke();
        Assert.assertFalse((String)"Client is choked after unchoke call", (boolean)cut.isChoked());
    }

    @Test
    public void testInterested() {
        Client cut = new Client();
        cut.interested();
        Assert.assertTrue((String)"Client is uninterested after interested call", (boolean)cut.isInterested());
        cut.uninterested();
        Assert.assertFalse((String)"Client is interested after uninterested call", (boolean)cut.isInterested());
    }

    @Test
    public void testAddJob() {
        Client cut = new Client();
        cut.addJob(new Job(1, 2, 3));
        Assert.assertEquals((String)"Job did not get added", (long)1L, (long)cut.getQueueSize());
    }

    @Test
    public void testGetNextJob() {
        Client cut = new Client();
        Job job = new Job(1, 2, 3);
        cut.addJob(job);
        Job returnedJob = cut.popNextJob();
        Assert.assertEquals((String)"Incorrect job got returned", (Object)job, (Object)returnedJob);
        Assert.assertEquals((String)"Job did not get removed", (long)0L, (long)cut.getQueueSize());
    }

    @Test
    public void testRemoveJob() {
        Client cut = new Client();
        Job jobOne = new Job(1, 2, 3);
        Job jobTwo = new Job(2, 3, 4);
        cut.addJob(jobOne);
        cut.addJob(jobTwo);
        Assert.assertEquals((String)"Incorrect amount of jobs before remove", (long)2L, (long)cut.getQueueSize());
        cut.removeJob(jobTwo);
        Assert.assertEquals((String)"Incorrect amount of jobs after remove", (long)1L, (long)cut.getQueueSize());
        Job returnedJob = cut.popNextJob();
        Assert.assertEquals((String)"Incorrect job got returned", (Object)jobOne, (Object)returnedJob);
    }

    @Test
    public void testClearJobs() {
        Client cut = new Client();
        cut.addJob(new Job(1, 2, 3));
        cut.addJob(new Job(2, 3, 4));
        Assert.assertEquals((String)"Incorrect amount of jobs before clear", (long)2L, (long)cut.getQueueSize());
        cut.clearJobs();
        Assert.assertEquals((String)"Incorrect amount of jobs after clear", (long)0L, (long)cut.getQueueSize());
    }

    @Test
    public void testGetJobs() {
        Client cut = new Client();
        Job jobOne = new Job(1, 2, 3);
        Job jobTwo = new Job(2, 3, 4);
        ArrayList<Job> jobs = new ArrayList<Job>();
        jobs.add(jobOne);
        jobs.add(jobTwo);
        cut.addJob(jobOne);
        cut.addJob(jobTwo);
        Assert.assertEquals((String)"Incorrect amount of jobs before getting all", (long)2L, (long)cut.getQueueSize());
        for (Job job : cut.getJobs()) {
            Assert.assertTrue((String)"Incorrect job returned", (boolean)jobs.contains(job));
            jobs.remove(job);
        }
    }
}

