/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentHandshake;
import org.johnnei.javatorrent.bittorrent.protocol.MessageFactory;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageKeepAlive;
import org.johnnei.javatorrent.internal.network.ByteInputStream;
import org.johnnei.javatorrent.internal.network.ByteOutputStream;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.network.BitTorrentSocketException;
import org.johnnei.javatorrent.network.ConnectionDegradation;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.test.TestLinkedClock;
import org.johnnei.javatorrent.test.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.powermock.reflect.Whitebox;

public class BitTorrentSocketTest
extends EasyMockSupport {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testConnect() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getLocalHost(), 27960);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        ISocket socketMockOne = (ISocket)this.createMock(ISocket.class);
        ISocket socketMockTwo = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMockTwo.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMockTwo.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)connectionDegradationMock.createPreferredSocket()).andReturn((Object)socketMockOne);
        EasyMock.expect((Object)socketMockOne.isClosed()).andReturn((Object)true);
        socketMockOne.connect((InetSocketAddress)EasyMock.eq((Object)socketAddress));
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Fail on first connect"));
        EasyMock.expect((Object)connectionDegradationMock.degradeSocket((ISocket)EasyMock.same((Object)socketMockOne))).andReturn(Optional.of(socketMockTwo));
        EasyMock.expect((Object)socketMockTwo.isClosed()).andReturn((Object)true);
        socketMockTwo.connect((InetSocketAddress)EasyMock.eq((Object)socketAddress));
        EasyMock.expect((Object)socketMockTwo.isClosed()).andReturn((Object)false);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock);
        cut.connect(connectionDegradationMock, socketAddress);
        cut.connect(connectionDegradationMock, socketAddress);
        this.verifyAll();
    }

    @Test
    public void testConnectFailure() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getLocalHost(), 27960);
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        ISocket socketMockOne = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)connectionDegradationMock.createPreferredSocket()).andReturn((Object)socketMockOne);
        EasyMock.expect((Object)socketMockOne.isClosed()).andReturn((Object)true);
        socketMockOne.connect((InetSocketAddress)EasyMock.eq((Object)socketAddress));
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Fail on first connect"));
        EasyMock.expect((Object)connectionDegradationMock.degradeSocket((ISocket)EasyMock.same((Object)socketMockOne))).andReturn(Optional.empty());
        this.thrown.expect(BitTorrentSocketException.class);
        this.thrown.expectMessage("Connection Stack");
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock);
        cut.connect(connectionDegradationMock, socketAddress);
        this.verifyAll();
    }

    @Test
    public void testToString() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock);
        BitTorrentSocket cutTwo = new BitTorrentSocket(messageFactoryMock, socketMock);
        this.verifyAll();
        Assert.assertTrue((String)"Incorrect toString start", (boolean)cut.toString().startsWith("BitTorrentSocket["));
        Assert.assertEquals((String)"Incorrect socket name on null socket", (Object)"", (Object)cut.getSocketName());
        Assert.assertTrue((String)"Incorrect socket name on nonnull socket", (cutTwo.getSocketName().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsClosed() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)socketMock.isClosed()).andReturn((Object)false);
        EasyMock.expect((Object)socketMock.isClosed()).andReturn((Object)true);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock);
        BitTorrentSocket cutTwo = new BitTorrentSocket(messageFactoryMock, socketMock);
        Assert.assertTrue((String)"Null socket is always closed.", (boolean)cut.closed());
        Assert.assertFalse((String)"Socket is should have returned that it's closed.", (boolean)cutTwo.closed());
        Assert.assertTrue((String)"Socket is should have returned that it's NOT closed.", (boolean)cutTwo.closed());
        this.verifyAll();
    }

    @Test
    public void testGetSpeeds() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteInputStream inputStream = (ByteInputStream)this.createMock(ByteInputStream.class);
        ByteOutputStream outputStream = (ByteOutputStream)this.createMock(ByteOutputStream.class);
        EasyMock.expect((Object)inputStream.pollSpeed()).andReturn((Object)42);
        EasyMock.expect((Object)outputStream.pollSpeed()).andReturn((Object)7);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock);
        Whitebox.setInternalState((Object)cut, (String)"inStream", (Object)inputStream);
        Whitebox.setInternalState((Object)cut, (String)"outStream", (Object)outputStream);
        cut.pollRates();
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect download speed", (long)42L, (long)cut.getDownloadRate());
        Assert.assertEquals((String)"Incorrect upload speed", (long)7L, (long)cut.getUploadRate());
        BitTorrentSocket cutTwo = new BitTorrentSocket(messageFactoryMock);
        cutTwo.pollRates();
    }

    @Test
    public void testReadMessageKeepAlive() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[4]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.setPassedHandshake();
        Assert.assertTrue((String)"Should be able to read keep alive message", (boolean)cut.canReadMessage());
        Assert.assertTrue((String)"Incorrect message type", (boolean)(cut.readMessage() instanceof MessageKeepAlive));
        this.verifyAll();
    }

    @Test
    public void testCanReadMessageAfterThreeReads() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        IMessage messageMock = (IMessage)this.createMock(IMessage.class);
        messageMock.read((InStream)EasyMock.notNull());
        EasyMock.expect((Object)messageFactoryMock.createById(EasyMock.eq((int)1))).andReturn((Object)messageMock);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream inputStream = (InputStream)this.createMock(InputStream.class);
        EasyMock.expect((Object)inputStream.available()).andReturn((Object)2);
        EasyMock.expect((Object)inputStream.available()).andReturn((Object)4);
        EasyMock.expect((Object)inputStream.available()).andReturn((Object)0);
        EasyMock.expect((Object)inputStream.available()).andReturn((Object)1);
        Capture bufferCapture = EasyMock.newCapture();
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.capture((Capture)bufferCapture), EasyMock.eq((int)0), EasyMock.anyInt())).andAnswer(() -> {
            ((byte[])bufferCapture.getValue())[3] = 1;
            return 4;
        });
        EasyMock.expect((Object)inputStream.read((byte[])EasyMock.capture((Capture)bufferCapture), EasyMock.eq((int)0), EasyMock.anyInt())).andAnswer(() -> {
            ((byte[])bufferCapture.getValue())[0] = 1;
            return 1;
        });
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.setPassedHandshake();
        Assert.assertFalse((String)"Shouldn't be able to read message", (boolean)cut.canReadMessage());
        Assert.assertFalse((String)"Shouldn't be able to read message", (boolean)cut.canReadMessage());
        Assert.assertTrue((String)"Should be able to read message", (boolean)cut.canReadMessage());
        Assert.assertEquals((String)"Incorrect message type", (Object)messageMock, (Object)cut.readMessage());
        this.verifyAll();
    }

    @Test
    public void testCanReadMessageNotEnoughBytes() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{0, 0});
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.setPassedHandshake();
        Assert.assertFalse((String)"Should be able to read message", (boolean)cut.canReadMessage());
        this.verifyAll();
    }

    @Test
    public void testReadMessage() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        IMessage messageMock = (IMessage)this.createMock(IMessage.class);
        EasyMock.expect((Object)messageFactoryMock.createById(EasyMock.eq((int)1))).andReturn((Object)messageMock);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[]{0, 0, 0, 1, 1});
        messageMock.read((InStream)EasyMock.notNull());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.setPassedHandshake();
        Assert.assertTrue((String)"Should be able to read message", (boolean)cut.canReadMessage());
        Assert.assertEquals((String)"Incorrect message type", (Object)messageMock, (Object)cut.readMessage());
        this.verifyAll();
    }

    @Test(expected=IllegalStateException.class)
    public void testCantReadHandshakeTwice() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.setPassedHandshake();
        cut.readHandshake();
    }

    @Test(expected=IllegalStateException.class)
    public void testCantSendHandshakeTwice() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.setPassedHandshake();
        cut.sendHandshake(DummyEntity.createRandomBytes(8), DummyEntity.createPeerId(), DummyEntity.createUniqueTorrentHash(new byte[0][]));
    }

    @Test(expected=IOException.class)
    public void testReadHandshakeTimeout() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        Clock baseClock = Clock.fixed(Clock.systemDefaultZone().instant(), Clock.systemDefaultZone().getZone());
        TestLinkedClock clock = new TestLinkedClock(new LinkedList<Clock>(Arrays.asList(baseClock, baseClock, Clock.offset(baseClock, Duration.ofSeconds(1L)), Clock.offset(baseClock, Duration.ofSeconds(2L)), Clock.offset(baseClock, Duration.ofSeconds(4L)), Clock.offset(baseClock, Duration.ofSeconds(6L)))));
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        Whitebox.setInternalState((Object)cut, (String)"clock", (Object)clock);
        cut.readHandshake();
    }

    @Test(expected=IOException.class)
    public void testReadHandshakeIncorrectProtocolName() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        byte[] inputBytes = new byte[]{19, 66, 105, 117, 84, 111, 114, 114, 101, 110, 116, 32, 112, 114, 111, 117, 111, 99, 111, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inputBytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.readHandshake();
        this.verifyAll();
    }

    @Test(expected=IOException.class)
    public void testReadHandshakeIncorrectProtocolLength() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        byte[] inputBytes = new byte[]{69, 66, 105, 116, 84, 111, 114, 114, 101, 110, 116, 32, 112, 114, 111, 116, 111, 99, 111, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inputBytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.readHandshake();
        this.verifyAll();
    }

    @Test
    public void testClose() throws Exception {
        MessageFactory messageFactory = (MessageFactory)this.createMock(MessageFactory.class);
        ISocket socketOneMock = (ISocket)this.createMock(ISocket.class);
        ISocket socketTwoMock = (ISocket)this.createMock(ISocket.class);
        ISocket socketThreeMock = (ISocket)this.createMock(ISocket.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        EasyMock.expect((Object)socketOneMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketOneMock.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)socketTwoMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketTwoMock.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)socketThreeMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketThreeMock.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)socketOneMock.isClosed()).andReturn((Object)true);
        EasyMock.expect((Object)socketTwoMock.isClosed()).andReturn((Object)false);
        EasyMock.expect((Object)socketThreeMock.isClosed()).andReturn((Object)false);
        socketTwoMock.close();
        socketThreeMock.close();
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Test Exception path"));
        this.replayAll();
        new BitTorrentSocket(messageFactory, socketOneMock).close();
        new BitTorrentSocket(messageFactory, socketTwoMock).close();
        new BitTorrentSocket(messageFactory, socketThreeMock).close();
        this.verifyAll();
    }

    @Test
    public void testReadHandshake() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        byte[] inputBytes = new byte[]{19, 66, 105, 116, 84, 111, 114, 114, 101, 110, 116, 32, 112, 114, 111, 116, 111, 99, 111, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] extensionBytes = DummyEntity.createRandomBytes(8);
        byte[] peerId = DummyEntity.createPeerId();
        byte[] torrentHash = DummyEntity.createUniqueTorrentHash(new byte[0][]);
        TestUtils.copySection(extensionBytes, inputBytes, 20);
        TestUtils.copySection(torrentHash, inputBytes, 28);
        TestUtils.copySection(peerId, inputBytes, 48);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inputBytes);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        Assert.assertFalse((String)"Did pass handshake before handshake has completed.", (boolean)cut.getPassedHandshake());
        BitTorrentHandshake handshake = cut.readHandshake();
        Assert.assertArrayEquals((String)"Incorrect extension bytes", (byte[])extensionBytes, (byte[])handshake.getPeerExtensionBytes());
        Assert.assertArrayEquals((String)"Incorrect peer id", (byte[])peerId, (byte[])handshake.getPeerId());
        Assert.assertArrayEquals((String)"Incorrect torrent hash", (byte[])torrentHash, (byte[])handshake.getTorrentHash());
        this.verifyAll();
    }

    @Test
    public void testSendHandshake() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        byte[] expectedOutput = new byte[]{19, 66, 105, 116, 84, 111, 114, 114, 101, 110, 116, 32, 112, 114, 111, 116, 111, 99, 111, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] extensionBytes = DummyEntity.createRandomBytes(8);
        byte[] peerId = DummyEntity.createPeerId();
        byte[] torrentHash = DummyEntity.createUniqueTorrentHash(new byte[0][]);
        TestUtils.copySection(extensionBytes, expectedOutput, 20);
        TestUtils.copySection(torrentHash, expectedOutput, 28);
        TestUtils.copySection(peerId, expectedOutput, 48);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(expectedOutput);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.sendHandshake(extensionBytes, peerId, torrentHash);
        this.verifyAll();
        Assert.assertArrayEquals((String)"Incorrect output bytes", (byte[])expectedOutput, (byte[])outputStream.toByteArray());
    }

    @Test
    public void testEnqueueMessage() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        IMessage messageMock = (IMessage)this.createMock(IMessage.class);
        IMessage pieceMessageMock = (IMessage)this.createMock(MessageBlock.class);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        Assert.assertFalse((String)"0 messages are pending, has outbound should be false", (boolean)cut.hasOutboundMessages());
        cut.enqueueMessage(pieceMessageMock);
        Assert.assertTrue((String)"Block queue must have 1 message", (((Queue)Whitebox.getInternalState((Object)cut, (String)"blockQueue")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1 message is pending, has outbound should be true", (boolean)cut.hasOutboundMessages());
        cut.enqueueMessage(messageMock);
        Assert.assertTrue((String)"Block queue must have 1 message", (((Queue)Whitebox.getInternalState((Object)cut, (String)"blockQueue")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Message queue must have 1 message", (((Queue)Whitebox.getInternalState((Object)cut, (String)"messageQueue")).size() == 1 ? 1 : 0) != 0);
        this.verifyAll();
        Assert.assertTrue((String)"2 messages are pending, has outbound should be true", (boolean)cut.hasOutboundMessages());
    }

    @Test
    public void testSendMessageNoMessagesQueued() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        cut.sendMessage();
        this.verifyAll();
    }

    @Test
    public void testSendMessage() throws Exception {
        Clock clock = Clock.fixed(Clock.offset(Clock.systemDefaultZone(), Duration.ofSeconds(1L)).instant(), Clock.systemDefaultZone().getZone());
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ISocket socketMock = (ISocket)this.createMock(ISocket.class);
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)outputStream);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)inputStream);
        IMessage messageMock = (IMessage)this.createMock(MessageKeepAlive.class);
        IMessage pieceMessageMock = (IMessage)this.createMock(MessageBlock.class);
        EasyMock.expect((Object)pieceMessageMock.getId()).andReturn((Object)7);
        EasyMock.expect((Object)messageMock.getLength()).andReturn((Object)0).times(3);
        byte[] randomBytes = DummyEntity.createRandomBytes(5);
        EasyMock.expect((Object)pieceMessageMock.getLength()).andReturn((Object)randomBytes.length).times(3);
        Capture outStreamCapture = EasyMock.newCapture();
        pieceMessageMock.write((OutStream)EasyMock.capture((Capture)outStreamCapture));
        EasyMock.expectLastCall().andAnswer(() -> {
            ((OutStream)outStreamCapture.getValue()).write(randomBytes);
            return null;
        });
        this.replayAll();
        BitTorrentSocket cut = new BitTorrentSocket(messageFactoryMock, socketMock);
        Whitebox.setInternalState((Object)cut, (String)"clock", (Object)clock);
        cut.enqueueMessage(messageMock);
        cut.enqueueMessage(pieceMessageMock);
        cut.sendMessage();
        Assert.assertArrayEquals((String)"Incorrect keep alive output.", (byte[])new byte[4], (byte[])outputStream.toByteArray());
        outputStream.reset();
        cut.sendMessage();
        byte[] expectedBytes = new byte[5 + randomBytes.length];
        expectedBytes[3] = (byte)randomBytes.length;
        expectedBytes[4] = 7;
        TestUtils.copySection(randomBytes, expectedBytes, 5);
        Assert.assertArrayEquals((String)"Incorrect piece output.", (byte[])expectedBytes, (byte[])outputStream.toByteArray());
        outputStream.reset();
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect last activity timestamp", (Object)LocalDateTime.now(clock), (Object)cut.getLastActivity());
    }
}

