/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.phases;

import java.util.Optional;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.phases.PhaseRegulator;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.choking.IChokingStrategy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class PhaseRegulatorTest
extends EasyMockSupport {
    @Test
    public void testCreateInitialPhase() {
        IDownloadPhase downloadPhaseMock = (IDownloadPhase)this.createMock(IDownloadPhase.class);
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        this.replayAll();
        PhaseRegulator regulator = new PhaseRegulator.Builder().registerInitialPhase(IDownloadPhase.class, (client, torrent) -> downloadPhaseMock, Optional.empty()).build();
        IDownloadPhase downloadPhase = regulator.createInitialPhase(torrentClientMock, torrentMock);
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect initial phase returned", (Object)downloadPhaseMock, (Object)downloadPhase);
    }

    @Test
    public void testCreateInitialPhaseOverridenInitial() {
        IDownloadPhase downloadPhaseMock = (IDownloadPhase)this.createMock(IDownloadPhase.class);
        SecondPhase secondPhaseMock = (SecondPhase)this.createMock(SecondPhase.class);
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        this.replayAll();
        PhaseRegulator regulator = new PhaseRegulator.Builder().registerInitialPhase(IDownloadPhase.class, (client, torrent) -> downloadPhaseMock, Optional.empty()).registerInitialPhase(SecondPhase.class, (client, torrent) -> secondPhaseMock, Optional.empty()).build();
        IDownloadPhase downloadPhase = regulator.createInitialPhase(torrentClientMock, torrentMock);
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect initial phase returned", (Object)secondPhaseMock, (Object)downloadPhase);
    }

    @Test
    public void testCreateNextPhase() {
        FirstPhase firstPhase = new FirstPhase();
        SecondPhase secondPhase = new SecondPhase();
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        this.replayAll();
        PhaseRegulator regulator = new PhaseRegulator.Builder().registerInitialPhase(FirstPhase.class, (client, torrent) -> firstPhase, Optional.of(SecondPhase.class)).registerPhase(SecondPhase.class, (client, torrent) -> secondPhase, Optional.empty()).build();
        Optional downloadPhase = regulator.createNextPhase((IDownloadPhase)firstPhase, torrentClientMock, torrentMock);
        Optional thirdPhase = regulator.createNextPhase((IDownloadPhase)secondPhase, torrentClientMock, torrentMock);
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect initial phase returned", (Object)secondPhase, downloadPhase.get());
        Assert.assertFalse((String)"Third phase got returned but wasn't configured.", (boolean)thirdPhase.isPresent());
    }

    @Test
    public void testToString() {
        FirstPhase firstPhase = new FirstPhase();
        SecondPhase secondPhase = new SecondPhase();
        this.replayAll();
        PhaseRegulator regulator = new PhaseRegulator.Builder().registerInitialPhase(IDownloadPhase.class, (client, torrent) -> firstPhase, Optional.of(SecondPhase.class)).registerPhase(SecondPhase.class, (client, torrent) -> secondPhase, Optional.empty()).build();
        this.verifyAll();
        Assert.assertTrue((String)"Incorrect toString start", (boolean)regulator.toString().startsWith("PhaseRegulator["));
    }

    @Test(expected=IllegalStateException.class)
    public void testDuplicatePhase() {
        FirstPhase firstPhase = new FirstPhase();
        new PhaseRegulator.Builder().registerInitialPhase(FirstPhase.class, (client, torrent) -> firstPhase, Optional.empty()).registerPhase(FirstPhase.class, (client, torrent) -> firstPhase, Optional.empty());
    }

    @Test(expected=IllegalStateException.class)
    public void testBuildWithoutConfiguration() {
        new PhaseRegulator.Builder().build();
    }

    private static class SecondPhase
    implements IDownloadPhase {
        private SecondPhase() {
        }

        public boolean isDone() {
            return false;
        }

        public void process() {
        }

        public void onPhaseEnter() {
        }

        public void onPhaseExit() {
        }

        public IChokingStrategy getChokingStrategy() {
            return null;
        }
    }

    private static class FirstPhase
    implements IDownloadPhase {
        private FirstPhase() {
        }

        public boolean isDone() {
            return false;
        }

        public void process() {
        }

        public void onPhaseEnter() {
        }

        public void onPhaseExit() {
        }

        public IChokingStrategy getChokingStrategy() {
            return null;
        }
    }
}

