/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.phases.PhaseRegulator;
import org.johnnei.javatorrent.test.ExecutorServiceMock;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.tracker.IPeerConnector;

public class StubEntity {
    public static TorrentClient stubTorrentClient(EasyMockSupport context) {
        IPeerConnector peerConnectorMock = (IPeerConnector)context.createMock(IPeerConnector.class);
        TorrentClient torrentClientMock = (TorrentClient)context.createMock(TorrentClient.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)context.createMock(PhaseRegulator.class);
        IDownloadPhase downloadPhaseMock = (IDownloadPhase)context.createMock(IDownloadPhase.class);
        ExecutorServiceMock service = new ExecutorServiceMock();
        EasyMock.expect((Object)torrentClientMock.getPeerConnector()).andStubReturn((Object)peerConnectorMock);
        EasyMock.expect((Object)torrentClientMock.getExecutorService()).andStubReturn((Object)service);
        EasyMock.expect((Object)torrentClientMock.getPhaseRegulator()).andStubReturn((Object)phaseRegulatorMock);
        EasyMock.expect((Object)phaseRegulatorMock.createInitialPhase((TorrentClient)EasyMock.eq((Object)torrentClientMock), (Torrent)EasyMock.notNull())).andStubReturn((Object)downloadPhaseMock);
        return torrentClientMock;
    }

    public static AbstractFileSet stubAFiles(int pieceCount) {
        return new AFilesStub(pieceCount);
    }

    public static AbstractFileSet stubAFiles(int pieceCount, FileInfo fileInfo) {
        return new AFilesStub(pieceCount, fileInfo);
    }

    public static AbstractFileSet stubAFiles(int pieceCount, FileInfo fileInfo, int blockSize) {
        return new AFilesStub(pieceCount, fileInfo, blockSize);
    }

    private static final class AFilesStub
    extends AbstractFileSet {
        private int blockSize;

        public AFilesStub(int pieceCount, FileInfo defaultFile, int blockSize) {
            this(pieceCount, defaultFile);
            this.blockSize = blockSize;
        }

        public AFilesStub(int pieceCount, FileInfo defaultFile) {
            this(pieceCount);
            this.fileInfos = Collections.singletonList(defaultFile);
        }

        public AFilesStub(int pieceCount) {
            super(1);
            this.fileInfos = new ArrayList();
            this.fileInfos.add(new FileInfo(1L, 0L, new File("./target/tmp/afilesstub.tmp"), pieceCount));
            this.pieces = new ArrayList();
            for (int i = 0; i < pieceCount; ++i) {
                this.pieces.add(new Piece((AbstractFileSet)this, new byte[0], i, 1, 1));
            }
        }

        public void setHavingPiece(int pieceIndex) throws NoSuchElementException {
        }

        public boolean hasPiece(int pieceIndex) throws NoSuchElementException {
            return false;
        }

        public long getPieceSize() {
            return 0L;
        }

        public FileInfo getFileForBytes(int index, int blockIndex, int blockDataOffset) {
            return (FileInfo)this.fileInfos.get(0);
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public byte[] getBitfieldBytes() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

