/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.test;

import java.lang.reflect.Constructor;
import java.util.Optional;
import org.junit.Assert;

public class TestUtils {
    private TestUtils() {
    }

    public static void copySection(byte[] from, byte[] to, int targetStart) {
        TestUtils.copySection(from, to, targetStart, 0, from.length);
    }

    public static void copySection(byte[] from, byte[] to, int targetStart, int start, int count) {
        for (int i = 0; i < count; ++i) {
            to[targetStart + i] = from[start + i];
        }
    }

    public static void assertEqualsMethod(Object o) {
        Assert.assertTrue((String)"Same object instance aren't equal", (boolean)o.equals(o));
        Assert.assertFalse((String)"Object equals with null", (boolean)o.equals(null));
        Assert.assertFalse((String)"Object matches with not castable type", (boolean)o.equals(7));
    }

    public static void assertEqualityMethods(Object base, Object equalToBase, Object ... notEqualToBase) {
        TestUtils.assertEqualsMethod(base);
        Assert.assertTrue((String)"Base didn't equal with the given equal", (boolean)base.equals(equalToBase));
        Assert.assertEquals((String)"Base hashcode didn't match with given equal", (long)base.hashCode(), (long)equalToBase.hashCode());
        for (Object notEqual : notEqualToBase) {
            Assert.assertFalse((String)"Base did match with the given non-equal", (boolean)base.equals(notEqual));
        }
    }

    public static void assertNotPresent(String message, Optional<?> optional) {
        Assert.assertFalse((String)message, (boolean)optional.isPresent());
    }

    public static void assertPresent(String message, Optional<?> optional) {
        Assert.assertTrue((String)message, (boolean)optional.isPresent());
    }

    public static void assertUtilityClassConstructor(Class<?> clazz) throws Exception {
        Constructor<?>[] constructor = clazz.getDeclaredConstructors();
        Assert.assertEquals((String)"Incorrect amount of constructors for util class", (long)1L, (long)constructor.length);
        Assert.assertFalse((String)"Incorrect accessibility for constructor", (boolean)constructor[0].isAccessible());
        constructor[0].setAccessible(true);
        constructor[0].newInstance(new Object[0]);
    }
}

