/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.encoding.SHA1;
import org.johnnei.javatorrent.internal.network.socket.TcpSocket;
import org.johnnei.javatorrent.network.ConnectionDegradation;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.phases.PhaseData;
import org.johnnei.javatorrent.phases.PhaseRegulator;
import org.johnnei.javatorrent.phases.PhaseSeed;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.PeerConnector;
import org.johnnei.javatorrent.tracker.UncappedDistributor;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTorrentIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTorrentIT.class);
    private static final String SINGLE_FILE_TORRENT = "gimp-2.8.16-setup-1.exe.torrent";
    private static final byte[] TORRENT_FILE_HASH = new byte[]{-56, 54, -97, 11, -92, -65, 108, -40, 127, -79, 59, 52, 55, 120, 46, 44, 120, 32, -69, 56};
    private static final int PIECE_SIZE = 262144;
    private static final String EXECUTABLE_NAME = "gimp-2.8.16-setup-1.exe";
    private static final byte[] EXECUTABLE_HASH = new byte[]{-127, 109, -46, 72, -1, 24, -126, 53, -25, -117, 109, 69, -65, -20, 62, 121, -32, -52, 8, -31};
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public Timeout timeout = new Timeout(20L, TimeUnit.MINUTES);

    private void assertPreconditions(File torrentFile, File resultFile) throws Exception {
        if (!resultFile.exists()) {
            Assert.fail((String)("Missing torrent output file: " + resultFile.getAbsolutePath()));
        }
        byte[] bytes = new byte[(int)resultFile.length()];
        try (DataInputStream inputStream = new DataInputStream(new FileInputStream(resultFile));){
            inputStream.readFully(bytes);
        }
        Assert.assertArrayEquals((String)"The output file used to setup the test has a mismatching hash.", (byte[])EXECUTABLE_HASH, (byte[])SHA1.hash((byte[])bytes));
        bytes = new byte[(int)torrentFile.length()];
        inputStream = new DataInputStream(new FileInputStream(torrentFile));
        var5_5 = null;
        try {
            inputStream.readFully(bytes);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var5_5 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        Assert.assertArrayEquals((String)"The torrent file used to setup the test has a mismatching hash.", (byte[])TORRENT_FILE_HASH, (byte[])SHA1.hash((byte[])bytes));
    }

    private void setUpFile(File sourceFile, File folder, int startingByte, int length) throws Exception {
        File outputFile = new File(folder, EXECUTABLE_NAME);
        Assert.assertTrue((String)"Failed to create download directoty", (boolean)outputFile.mkdir());
        outputFile = new File(outputFile, EXECUTABLE_NAME);
        Assert.assertTrue((String)"Failed to create temporary copy of result file", (boolean)outputFile.createNewFile());
        byte[] data = new byte[length];
        try (DataInputStream inputStream = new DataInputStream(new FileInputStream(sourceFile));){
            inputStream.skipBytes(startingByte);
            inputStream.readFully(data);
        }
        var8_8 = null;
        try (RandomAccessFile fileAccess = new RandomAccessFile(outputFile, "rw");){
            fileAccess.setLength(sourceFile.length());
            fileAccess.seek(startingByte);
            fileAccess.write(data);
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    protected TorrentClient createTorrentClient(CountDownLatch latch) throws Exception {
        return new TorrentClient.Builder().acceptIncomingConnections(true).setConnectionDegradation(new ConnectionDegradation.Builder().registerDefaultConnectionType(TcpSocket.class, TcpSocket::new, Optional.empty()).build()).setDownloadPort(DummyEntity.findAvailableTcpPort()).setExecutorService(Executors.newScheduledThreadPool(2)).setPeerConnector(PeerConnector::new).setPeerDistributor(UncappedDistributor::new).registerTrackerProtocol("stub", (s, torrentClient) -> null).setPhaseRegulator(new PhaseRegulator.Builder().registerInitialPhase(PhaseData.class, PhaseData::new, Optional.of(PhaseSeedCountdown.class)).registerPhase(PhaseSeedCountdown.class, (torrentClient, torrent) -> new PhaseSeedCountdown(latch, (TorrentClient)torrentClient, (Torrent)torrent), Optional.empty()).build()).build();
    }

    private Torrent createTorrent(String name, TorrentClient client, File torrentFile, File downloadFolder) throws IOException {
        return new Torrent.Builder().setTorrentClient(client).setName(name).buildFromMetata(torrentFile, downloadFolder);
    }

    private void downloadTestFile(File resultFile) throws Exception {
        LOGGER.info("Downloading test files...");
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url("http://download.gimp.org/pub/gimp/v2.8/windows/gimp-2.8.16-setup-1.exe").build();
        Response response = client.newCall(request).execute();
        try (FileOutputStream outputStream = new FileOutputStream(resultFile);){
            int readBytes;
            InputStream inputStream = response.body().byteStream();
            byte[] buffer = new byte[32768];
            while ((readBytes = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, readBytes);
            }
        }
    }

    @Test
    public void testDownloadTorrent() throws Exception {
        File resultFile;
        URL resultFileUrl = DownloadTorrentIT.class.getResource("/torrent-output/gimp-2.8.16-setup-1.exe");
        if (resultFileUrl != null) {
            LOGGER.info("Found cached torrent output, using that. Location: {}", (Object)resultFileUrl);
            resultFile = new File(resultFileUrl.toURI());
        } else {
            resultFile = this.temporaryFolder.newFile();
            this.downloadTestFile(resultFile);
        }
        LOGGER.info("Verifying torrent files to be the correct ones.");
        File torrentFile = new File(DownloadTorrentIT.class.getResource(SINGLE_FILE_TORRENT).toURI());
        this.assertPreconditions(torrentFile, resultFile);
        LOGGER.info("Setting up test environment with two half completed downloads.");
        File downloadFolderOne = this.temporaryFolder.newFolder();
        File downloadFolderTwo = this.temporaryFolder.newFolder();
        int halfSize = (int)(resultFile.length() / 262144L) / 2 * 262144;
        this.setUpFile(resultFile, downloadFolderOne, 0, halfSize);
        this.setUpFile(resultFile, downloadFolderTwo, halfSize, (int)(resultFile.length() - (long)halfSize));
        LOGGER.info("Preparing torrent clients");
        CountDownLatch latch = new CountDownLatch(2);
        TorrentClient clientOne = this.createTorrentClient(latch);
        TorrentClient clientTwo = this.createTorrentClient(latch);
        LOGGER.info("Starting downloading");
        LOGGER.debug("[CLIENT ONE] Directory: {}, Port: {}", (Object)downloadFolderOne.getAbsolutePath(), (Object)clientOne.getDownloadPort());
        LOGGER.debug("[CLIENT TWO] Directory: {}, Port: {}", (Object)downloadFolderTwo.getAbsolutePath(), (Object)clientTwo.getDownloadPort());
        Torrent torrentOne = this.createTorrent("GIMP ONE", clientOne, torrentFile, downloadFolderOne);
        Torrent torrentTwo = this.createTorrent("GIMP TWO", clientTwo, torrentFile, downloadFolderTwo);
        clientOne.download(torrentOne);
        clientTwo.download(torrentTwo);
        Assert.assertEquals((String)"Incorrect amount of completed pieces for client one", (long)184L, (long)torrentOne.getFileSet().countCompletedPieces());
        Assert.assertEquals((String)"Incorrect amount of completed pieces for client two", (long)186L, (long)torrentTwo.getFileSet().countCompletedPieces());
        LOGGER.info("Adding peer connect request to client.");
        clientTwo.getPeerConnector().enqueuePeer(new PeerConnectInfo(torrentTwo, new InetSocketAddress("localhost", clientOne.getDownloadPort())));
        LOGGER.info("Waiting for download completion");
        do {
            int INTERVAL_IN_SECONDS = 10;
            latch.await(10L, TimeUnit.SECONDS);
            torrentOne.pollRates();
            torrentTwo.pollRates();
            LOGGER.debug("[CLIENT ONE] Download: {}KiB/s, Upload: {}KiB/s [CLIENT TWO] Download: {}KiB/s, Upload: {}KiB/s", new Object[]{torrentOne.getDownloadRate() / 1024 / 10, torrentOne.getUploadRate() / 1024 / 10, torrentTwo.getDownloadRate() / 1024 / 10, torrentTwo.getUploadRate() / 1024 / 10});
        } while (latch.getCount() > 0L);
        clientOne.shutdown();
        clientTwo.shutdown();
    }

    protected static class PhaseSeedCountdown
    extends PhaseSeed {
        private final CountDownLatch latch;

        public PhaseSeedCountdown(CountDownLatch latch, TorrentClient torrentClient, Torrent torrent) {
            super(torrentClient, torrent);
            this.latch = latch;
        }

        public void onPhaseEnter() {
            this.latch.countDown();
            super.onPhaseEnter();
        }
    }
}

