/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.File;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.torrent.MetadataFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.TorrentFileSetTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class MetadataFileSetTest {
    private static final String SINGLE_FILE_TORRENT = "gimp-2.8.16-setup-1.exe.torrent";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testConstructorNullTorrent() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Torrent");
        new MetadataFileSet(null, this.temporaryFolder.newFile());
    }

    @Test
    public void testConstructorNullMetadata() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Metadata");
        new MetadataFileSet(DummyEntity.createUniqueTorrent(new Torrent[0]), null);
    }

    @Test
    public void testConstructorNonExistingMetadata() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Metadata");
        new MetadataFileSet(DummyEntity.createUniqueTorrent(new Torrent[0]), new File("dfasfsdgafhjkdsafdjhask.torrent"));
    }

    @Test
    public void testConstructor() throws Exception {
        File torrentFile = new File(TorrentFileSetTest.class.getResource(SINGLE_FILE_TORRENT).toURI());
        MetadataFileSet cut = new MetadataFileSet(DummyEntity.createUniqueTorrent(new Torrent[0]), torrentFile);
        Assert.assertEquals((String)"Piece size should be equal to the file size", (long)torrentFile.length(), (long)cut.getPieceSize());
        Assert.assertEquals((String)"Total size should be equal to the file size", (long)torrentFile.length(), (long)cut.getTotalFileSize());
    }

    @Test
    public void getBitfieldBytes() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("UT_METADATA");
        File torrentFile = new File(TorrentFileSetTest.class.getResource(SINGLE_FILE_TORRENT).toURI());
        MetadataFileSet cut = new MetadataFileSet(DummyEntity.createUniqueTorrent(new Torrent[0]), torrentFile);
        cut.getBitfieldBytes();
    }
}

