/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.algos.choking;

import java.util.stream.Stream;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.choking.PermissiveStrategy;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class PermissiveStrategyTest
extends EasyMockSupport {
    @Test
    public void testUpdateChokingChoke() throws Exception {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet filesMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece piece = new Piece(null, new byte[0], 1, 1, 1);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)filesMock);
        EasyMock.expect((Object)filesMock.getNeededPieces()).andStubReturn(Stream.of(piece));
        Peer peerMock = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andReturn((Object)torrentMock);
        EasyMock.expect((Object)peerMock.hasPiece(EasyMock.eq((int)1))).andReturn((Object)true);
        EasyMock.expect((Object)peerMock.isInterested((PeerDirection)EasyMock.eq((Object)PeerDirection.Download))).andReturn((Object)true);
        EasyMock.expect((Object)peerMock.isInterested((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload))).andReturn((Object)false);
        EasyMock.expect((Object)peerMock.isChoked((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload))).andReturn((Object)false);
        peerMock.setChoked((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload), EasyMock.eq((boolean)true));
        this.replayAll();
        PermissiveStrategy cut = new PermissiveStrategy();
        cut.updateChoking(peerMock);
        this.verifyAll();
    }

    @Test
    public void testUpdateChokingUnchoke() throws Exception {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet filesMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece piece = new Piece(null, new byte[0], 1, 1, 1);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)filesMock);
        EasyMock.expect((Object)filesMock.getNeededPieces()).andStubReturn(Stream.of(piece));
        Peer peerMock = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andReturn((Object)torrentMock);
        EasyMock.expect((Object)peerMock.hasPiece(EasyMock.eq((int)1))).andReturn((Object)true);
        EasyMock.expect((Object)peerMock.isInterested((PeerDirection)EasyMock.eq((Object)PeerDirection.Download))).andReturn((Object)true);
        EasyMock.expect((Object)peerMock.isInterested((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload))).andReturn((Object)true);
        EasyMock.expect((Object)peerMock.isChoked((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload))).andReturn((Object)true);
        peerMock.setChoked((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload), EasyMock.eq((boolean)false));
        this.replayAll();
        PermissiveStrategy cut = new PermissiveStrategy();
        cut.updateChoking(peerMock);
        this.verifyAll();
    }

    @Test
    public void testUpdateChokingUpdateInterested() throws Exception {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet filesMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece piece = new Piece(null, new byte[0], 1, 1, 1);
        EasyMock.expect((Object)torrentMock.getFileSet()).andStubReturn((Object)filesMock);
        EasyMock.expect((Object)filesMock.getNeededPieces()).andStubReturn(Stream.of(piece));
        Peer peerMock = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andReturn((Object)torrentMock);
        EasyMock.expect((Object)peerMock.hasPiece(EasyMock.eq((int)1))).andReturn((Object)true);
        EasyMock.expect((Object)peerMock.isInterested((PeerDirection)EasyMock.eq((Object)PeerDirection.Download))).andReturn((Object)false);
        EasyMock.expect((Object)peerMock.isInterested((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload))).andReturn((Object)false);
        EasyMock.expect((Object)peerMock.isChoked((PeerDirection)EasyMock.eq((Object)PeerDirection.Upload))).andReturn((Object)true);
        peerMock.setInterested((PeerDirection)EasyMock.eq((Object)PeerDirection.Download), EasyMock.eq((boolean)true));
        this.replayAll();
        PermissiveStrategy cut = new PermissiveStrategy();
        cut.updateChoking(peerMock);
        this.verifyAll();
    }
}

