/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.algos.choking;

import org.johnnei.javatorrent.torrent.algos.choking.PermissiveUploadStrategy;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PermissiveUploadStrategyTest {
    @Test
    public void testUpdateChokingDontSwitchState() throws Exception {
        Peer peerMock = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peerMock.isInterested(PeerDirection.Upload)).thenReturn((Object)false);
        Mockito.when((Object)peerMock.isChoked(PeerDirection.Upload)).thenReturn((Object)true);
        PermissiveUploadStrategy cut = new PermissiveUploadStrategy();
        cut.updateChoking(peerMock);
        ((Peer)Mockito.verify((Object)peerMock, (VerificationMode)Mockito.never())).setChoked((PeerDirection)Matchers.eq((Object)PeerDirection.Upload), Matchers.anyBoolean());
    }

    @Test
    public void testUpdateChokingSwitchStateToFalse() throws Exception {
        Peer peerMock = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peerMock.isInterested(PeerDirection.Upload)).thenReturn((Object)true);
        Mockito.when((Object)peerMock.isChoked(PeerDirection.Upload)).thenReturn((Object)true);
        PermissiveUploadStrategy cut = new PermissiveUploadStrategy();
        cut.updateChoking(peerMock);
        ((Peer)Mockito.verify((Object)peerMock)).setChoked(PeerDirection.Upload, false);
    }

    @Test
    public void testUpdateChokingSwitchStateToTrue() throws Exception {
        Peer peerMock = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peerMock.isInterested(PeerDirection.Upload)).thenReturn((Object)false);
        Mockito.when((Object)peerMock.isChoked(PeerDirection.Upload)).thenReturn((Object)false);
        PermissiveUploadStrategy cut = new PermissiveUploadStrategy();
        cut.updateChoking(peerMock);
        ((Peer)Mockito.verify((Object)peerMock)).setChoked(PeerDirection.Upload, true);
    }
}

