/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.algos.pieceselector;

import java.util.Arrays;
import java.util.Optional;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.pieceselector.FullPieceSelect;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class FullPieceSelectTest {
    @Test
    public void testSelectStartedPiecesOverUnstarted() {
        Piece pieceOne = new Piece(null, new byte[20], 0, 10, 5);
        pieceOne.setBlockStatus(1, BlockStatus.Requested);
        Piece pieceTwo = new Piece(null, new byte[20], 1, 10, 5);
        AbstractFileSet filesMock = (AbstractFileSet)Mockito.mock(AbstractFileSet.class);
        Mockito.when((Object)filesMock.getNeededPieces()).thenReturn(Arrays.asList(pieceOne, pieceTwo).stream());
        Peer peerMock = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peerMock.hasPiece(Matchers.anyInt())).thenReturn((Object)true);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrentMock.getFileSet()).thenReturn((Object)filesMock);
        FullPieceSelect cut = new FullPieceSelect(torrentMock);
        Optional chosenPiece = cut.getPieceForPeer(peerMock);
        Assert.assertEquals((String)"Incorrect piece has been selected", (Object)pieceOne, chosenPiece.get());
    }

    @Test
    public void testSelectStartedPiecesOverUnstartedExcludingPiecesWithoutAnyNeededBlock() {
        Piece pieceOne = new Piece(null, new byte[20], 0, 10, 5);
        pieceOne.setBlockStatus(0, BlockStatus.Requested);
        pieceOne.setBlockStatus(1, BlockStatus.Requested);
        Piece pieceTwo = new Piece(null, new byte[20], 1, 10, 5);
        AbstractFileSet filesMock = (AbstractFileSet)Mockito.mock(AbstractFileSet.class);
        Mockito.when((Object)filesMock.getNeededPieces()).thenReturn(Arrays.asList(pieceOne, pieceTwo).stream());
        Peer peerMock = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peerMock.hasPiece(Matchers.anyInt())).thenReturn((Object)true);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrentMock.getFileSet()).thenReturn((Object)filesMock);
        FullPieceSelect cut = new FullPieceSelect(torrentMock);
        Optional chosenPiece = cut.getPieceForPeer(peerMock);
        Assert.assertEquals((String)"Incorrect piece has been selected", (Object)pieceTwo, chosenPiece.get());
    }

    @Test
    public void testSelectStartedPiecesOverUnstartedNonFirstElement() {
        Piece pieceOne = new Piece(null, new byte[20], 0, 10, 5);
        Piece pieceTwo = new Piece(null, new byte[20], 1, 10, 5);
        pieceTwo.setBlockStatus(1, BlockStatus.Requested);
        AbstractFileSet filesMock = (AbstractFileSet)Mockito.mock(AbstractFileSet.class);
        Mockito.when((Object)filesMock.getNeededPieces()).thenReturn(Arrays.asList(pieceOne, pieceTwo).stream());
        Peer peerMock = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peerMock.hasPiece(Matchers.anyInt())).thenReturn((Object)true);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrentMock.getFileSet()).thenReturn((Object)filesMock);
        FullPieceSelect cut = new FullPieceSelect(torrentMock);
        Optional chosenPiece = cut.getPieceForPeer(peerMock);
        Assert.assertEquals((String)"Incorrect piece has been selected", (Object)pieceTwo, chosenPiece.get());
    }

    @Test
    public void testPickRarerPieces() {
        Piece pieceOne = new Piece(null, new byte[20], 0, 10, 5);
        Piece pieceTwo = new Piece(null, new byte[20], 1, 10, 5);
        AbstractFileSet filesMock = (AbstractFileSet)Mockito.mock(AbstractFileSet.class);
        Mockito.when((Object)filesMock.getNeededPieces()).thenReturn(Arrays.asList(pieceOne, pieceTwo).stream());
        Peer peerMock = (Peer)Mockito.mock(Peer.class);
        Peer peerTwoMock = (Peer)Mockito.mock(Peer.class);
        Mockito.when((Object)peerMock.hasPiece(Matchers.anyInt())).thenReturn((Object)true);
        Mockito.when((Object)peerTwoMock.hasPiece(Matchers.eq((int)0))).thenReturn((Object)true);
        Mockito.when((Object)peerTwoMock.hasPiece(Matchers.eq((int)1))).thenReturn((Object)false);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrentMock.getFileSet()).thenReturn((Object)filesMock);
        Mockito.when((Object)torrentMock.getPeers()).thenReturn(Arrays.asList(peerMock, peerTwoMock));
        FullPieceSelect cut = new FullPieceSelect(torrentMock);
        Optional chosenPiece = cut.getPieceForPeer(peerMock);
        Assert.assertEquals((String)"Incorrect piece has been selected", (Object)pieceTwo, chosenPiece.get());
    }
}

