/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.download.tracker;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerFactory;
import org.johnnei.javatorrent.internal.tracker.TrackerManager;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.IPeerConnector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class TrackerManagerTest
extends EasyMockSupport {
    private TrackerManager cut;
    @Mock
    private IPeerConnector peerConnectorMock;
    @Mock
    private TrackerFactory trackerFactoryMock;

    @Before
    public void setUp() {
        this.cut = new TrackerManager(this.peerConnectorMock, this.trackerFactoryMock);
    }

    @Test
    public void testAnnounce() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        List<ITracker> trackers = Arrays.asList((ITracker)this.createMock(ITracker.class), (ITracker)this.createMock(ITracker.class));
        trackers.forEach(trackerMock -> {
            trackerMock.announce((Torrent)EasyMock.same((Object)torrentMock));
            EasyMock.expectLastCall();
        });
        EasyMock.expect((Object)this.trackerFactoryMock.getTrackersHavingTorrent((Torrent)EasyMock.same((Object)torrentMock))).andReturn(trackers);
        this.replayAll();
        this.cut.announce(torrentMock);
        this.verifyAll();
    }

    @Test
    public void testGetConnectingCountFor() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        int connectingCount = 5;
        EasyMock.expect((Object)this.peerConnectorMock.getConnectingCountFor((Torrent)EasyMock.same((Object)torrentMock))).andReturn((Object)5);
        this.replayAll();
        int connecting = this.cut.getConnectingCountFor(torrentMock);
        Assert.assertEquals((String)"Incorrect connecting amount", (long)5L, (long)connecting);
    }

    @Test
    public void testAddTorrent() {
        Torrent torrent = (Torrent)this.createMock(Torrent.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        String trackerUrl = "udp://localhost:80";
        String missingTrackerUrl = "udp://localhost:8080";
        EasyMock.expect((Object)this.trackerFactoryMock.getTrackerFor((String)EasyMock.eq((Object)"udp://localhost:80"))).andReturn(Optional.of(trackerMock));
        EasyMock.expect((Object)this.trackerFactoryMock.getTrackerFor((String)EasyMock.eq((Object)"udp://localhost:8080"))).andReturn(Optional.empty());
        trackerMock.addTorrent((Torrent)EasyMock.same((Object)torrent));
        this.replayAll();
        this.cut.addTorrent(torrent, "udp://localhost:8080");
        this.cut.addTorrent(torrent, "udp://localhost:80");
        this.verifyAll();
    }
}

