/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent.files;

import java.util.Optional;
import org.johnnei.javatorrent.test.TestUtils;
import org.johnnei.javatorrent.torrent.files.Block;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.junit.Assert;
import org.junit.Test;

public class PieceTest {
    @Test
    public void testStatusCounts() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        Assert.assertEquals((String)"Incorrect amount of blocks have been created", (long)10L, (long)piece.getBlockCount());
        Assert.assertEquals((String)"Incorrect amount of blocks with status Needed", (long)10L, (long)piece.countBlocksWithStatus(BlockStatus.Needed));
        Assert.assertTrue((String)"No piece with Needed status but there should be 10", (boolean)piece.hasBlockWithStatus(BlockStatus.Needed));
        Assert.assertFalse((String)"Piece is started but shouldn't be", (boolean)piece.isStarted());
        Assert.assertFalse((String)"Piece is done but shouldn't be", (boolean)piece.isDone());
        Assert.assertEquals((String)"Incorrect amount of bytes remaining", (long)50L, (long)piece.countRemainingBytes());
        piece.setBlockStatus(0, BlockStatus.Requested);
        Assert.assertTrue((String)"No piece with Requested status but there should be 1", (boolean)piece.hasBlockWithStatus(BlockStatus.Requested));
        piece.setBlockStatus(1, BlockStatus.Stored);
        Assert.assertTrue((String)"No piece with Stored status but there should be 1", (boolean)piece.hasBlockWithStatus(BlockStatus.Stored));
        piece.setBlockStatus(2, BlockStatus.Verified);
        Assert.assertTrue((String)"No piece with Verified status but there should be 1", (boolean)piece.hasBlockWithStatus(BlockStatus.Verified));
        Assert.assertEquals((String)"Incorrect amount of blocks with status Needed", (long)7L, (long)piece.countBlocksWithStatus(BlockStatus.Needed));
        Assert.assertEquals((String)"Incorrect amount of blocks with status Requested", (long)1L, (long)piece.countBlocksWithStatus(BlockStatus.Requested));
        Assert.assertEquals((String)"Incorrect amount of blocks with status Stored", (long)1L, (long)piece.countBlocksWithStatus(BlockStatus.Stored));
        Assert.assertEquals((String)"Incorrect amount of blocks with status Verified", (long)1L, (long)piece.countBlocksWithStatus(BlockStatus.Verified));
        Assert.assertEquals((String)"Incorrect amount of bytes remaining", (long)45L, (long)piece.countRemainingBytes());
        Assert.assertTrue((String)"Piece should be started but isn't", (boolean)piece.isStarted());
        Assert.assertFalse((String)"Piece shouldn't be done but is.", (boolean)piece.isDone());
        for (int i = 0; i < piece.getBlockCount(); ++i) {
            piece.setBlockStatus(i, BlockStatus.Verified);
        }
        Assert.assertTrue((String)"Piece should be started but isn't", (boolean)piece.isStarted());
        Assert.assertTrue((String)"Piece should be done but isn't.", (boolean)piece.isDone());
        Assert.assertEquals((String)"Incorrect amount of bytes remaining", (long)0L, (long)piece.countRemainingBytes());
    }

    @Test
    public void testGetRequestBlock() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        Optional blockOptional = piece.getRequestBlock();
        Assert.assertTrue((String)"Piece should have returned a block, but didn't", (boolean)blockOptional.isPresent());
        Assert.assertTrue((String)"Piece should be started but isn't", (boolean)piece.isStarted());
        Assert.assertEquals((String)"Incorrect piece has been returned", (long)0L, (long)((Block)blockOptional.get()).getIndex());
        Assert.assertEquals((String)"Incorrect block size", (long)5L, (long)((Block)blockOptional.get()).getSize());
        Assert.assertEquals((String)"Incorrect block size", (long)5L, (long)piece.getBlockSize(0));
        Assert.assertEquals((String)"Incorrect block status", (Object)BlockStatus.Requested, (Object)piece.getBlockStatus(0));
        Assert.assertEquals((String)"Incorrect block status", (Object)BlockStatus.Requested, (Object)((Block)blockOptional.get()).getStatus());
        for (int i = 1; i < piece.getBlockCount(); ++i) {
            blockOptional = piece.getRequestBlock();
            Assert.assertTrue((String)"Piece should have returned a block, but didn't", (boolean)blockOptional.isPresent());
            Assert.assertTrue((String)"Piece should be started but isn't", (boolean)piece.isStarted());
        }
        Assert.assertFalse((String)"Should not have returned a piece after all pieces have been requested", (boolean)piece.getRequestBlock().isPresent());
    }

    @Test
    public void testOnHashFail() {
        int i;
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        Assert.assertEquals((String)"Test relies on 10 pieces. Incorrect piece as starting state.", (long)10L, (long)piece.getBlockCount());
        for (i = 0; i < 10; ++i) {
            piece.setBlockStatus(i, BlockStatus.Verified);
        }
        Assert.assertTrue((String)"Piece should be done but isn't.", (boolean)piece.isDone());
        for (i = 0; i < 10; ++i) {
            piece.onHashMismatch();
            Assert.assertEquals((String)"Incorrect amount of pieces with status Verified", (long)9L, (long)piece.countBlocksWithStatus(BlockStatus.Verified));
            Assert.assertEquals((String)"Incorrect amount of pieces with status Needed", (long)1L, (long)piece.countBlocksWithStatus(BlockStatus.Needed));
            Assert.assertEquals((String)"Incorrect status for expected piece to be reset", (Object)BlockStatus.Needed, (Object)piece.getBlockStatus(i));
            piece.setBlockStatus(i, BlockStatus.Verified);
        }
    }

    @Test
    public void testToStringAndEqualsAndHashcode() {
        Piece pieceOne = new Piece(null, new byte[20], 0, 50, 5);
        Piece pieceTwo = new Piece(null, new byte[20], 0, 50, 5);
        Piece pieceThree = new Piece(null, new byte[20], 1, 50, 5);
        Assert.assertTrue((String)"Incorrect toString start", (boolean)pieceOne.toString().startsWith("Piece["));
        TestUtils.assertEqualityMethods(pieceOne, pieceTwo, pieceThree);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetStatusIAEUnderflow() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        piece.setBlockStatus(-1, BlockStatus.Needed);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetStatusIAEOverflow() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        piece.setBlockStatus(11, BlockStatus.Verified);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetStatusIAEUnderflow() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        piece.getBlockStatus(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetStatusIAEOverflow() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        piece.getBlockStatus(11);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSizeIAEUnderflow() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        piece.getBlockSize(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetSizeIAEOverflow() {
        Piece piece = new Piece(null, new byte[20], 0, 50, 5);
        piece.getBlockSize(11);
    }
}

