/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import java.util.List;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.EqualDistributor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class EqualDistributorTest {
    @Test
    public void testHasReachedPeerLimitTooManyTorrents() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)Mockito.mock(TorrentClient.class);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrentClientMock.getTorrentCount()).thenReturn((Object)6);
        EqualDistributor cut = new EqualDistributor(torrentClientMock, 5);
        Assert.assertFalse((String)"Limit should not have been reached yet (0 < 1)", (boolean)cut.hasReachedPeerLimit(torrentMock));
    }

    @Test
    public void testHasReachedPeerLimitTooManyTorrentsOverLimit() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)Mockito.mock(TorrentClient.class);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        List collectionMock = (List)Mockito.mock(List.class);
        Mockito.when((Object)torrentClientMock.getTorrentCount()).thenReturn((Object)6);
        Mockito.when((Object)torrentMock.getPeers()).thenReturn((Object)collectionMock);
        Mockito.when((Object)collectionMock.size()).thenReturn((Object)1);
        EqualDistributor cut = new EqualDistributor(torrentClientMock, 5);
        Assert.assertTrue((String)"Limit should have been reached (1 >= 1)", (boolean)cut.hasReachedPeerLimit(torrentMock));
    }

    @Test
    public void testHasReachedPeerLimit() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)Mockito.mock(TorrentClient.class);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrentClientMock.getTorrentCount()).thenReturn((Object)1);
        EqualDistributor cut = new EqualDistributor(torrentClientMock, 5);
        Assert.assertFalse((String)"Limit should not have been reached yet (1 < 5)", (boolean)cut.hasReachedPeerLimit(torrentMock));
    }

    @Test
    public void testHasReachedPeerLimitAtLimit() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)Mockito.mock(TorrentClient.class);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        List collectionMock = (List)Mockito.mock(List.class);
        Mockito.when((Object)torrentClientMock.getTorrentCount()).thenReturn((Object)1);
        Mockito.when((Object)torrentMock.getPeers()).thenReturn((Object)collectionMock);
        Mockito.when((Object)collectionMock.size()).thenReturn((Object)5);
        EqualDistributor cut = new EqualDistributor(torrentClientMock, 5);
        Assert.assertTrue((String)"Limit should have been reached (5 >= 5)", (boolean)cut.hasReachedPeerLimit(torrentMock));
    }

    @Test
    public void testHasReachedPeerLimitOverLimit() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)Mockito.mock(TorrentClient.class);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        List collectionMock = (List)Mockito.mock(List.class);
        Mockito.when((Object)torrentClientMock.getTorrentCount()).thenReturn((Object)1);
        Mockito.when((Object)torrentMock.getPeers()).thenReturn((Object)collectionMock);
        Mockito.when((Object)collectionMock.size()).thenReturn((Object)6);
        EqualDistributor cut = new EqualDistributor(torrentClientMock, 5);
        Assert.assertTrue((String)"Limit should have been reached (6 >= 5)", (boolean)cut.hasReachedPeerLimit(torrentMock));
    }
}

