/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import java.util.Arrays;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.IPeerConnector;
import org.johnnei.javatorrent.tracker.PeerConnectorPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public class PeerConnectorPoolTest
extends EasyMockSupport {
    private IPeerConnector peerConnectorMockOne;
    private IPeerConnector peerConnectorMockTwo;
    private PeerConnectorPool cut;

    @Before
    public void setUp() {
        this.peerConnectorMockOne = (IPeerConnector)this.createMock(IPeerConnector.class);
        this.peerConnectorMockTwo = (IPeerConnector)this.createMock(IPeerConnector.class);
        TorrentClient torrentClientMock = (TorrentClient)EasyMock.createMock(TorrentClient.class);
        EasyMock.replay((Object[])new Object[]{torrentClientMock});
        this.cut = new PeerConnectorPool(torrentClientMock, 2);
        EasyMock.verify((Object[])new Object[]{torrentClientMock});
        Whitebox.setInternalState((Object)this.cut, (String)"connectors", Arrays.asList(this.peerConnectorMockOne, this.peerConnectorMockTwo));
    }

    @Test
    public void testStart() throws Exception {
        this.peerConnectorMockOne.start();
        this.peerConnectorMockTwo.start();
        this.replayAll();
        this.cut.start();
        this.verifyAll();
    }

    @Test
    public void testStop() throws Exception {
        this.peerConnectorMockOne.stop();
        this.peerConnectorMockTwo.stop();
        this.replayAll();
        this.cut.stop();
        this.verifyAll();
    }

    @Test
    public void testEnqueuePeer() throws Exception {
        EasyMock.expect((Object)this.peerConnectorMockOne.getConnectingCount()).andStubReturn((Object)3);
        EasyMock.expect((Object)this.peerConnectorMockTwo.getConnectingCount()).andStubReturn((Object)2);
        PeerConnectInfo peerConnectInfoMock = (PeerConnectInfo)this.createMock(PeerConnectInfo.class);
        this.peerConnectorMockTwo.enqueuePeer((PeerConnectInfo)EasyMock.same((Object)peerConnectInfoMock));
        this.replayAll();
        this.cut.enqueuePeer(peerConnectInfoMock);
        this.verifyAll();
    }

    @Test
    public void testGetConnectingCountFor() throws Exception {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        EasyMock.expect((Object)this.peerConnectorMockOne.getConnectingCountFor((Torrent)EasyMock.same((Object)torrentMock))).andReturn((Object)3);
        EasyMock.expect((Object)this.peerConnectorMockTwo.getConnectingCountFor((Torrent)EasyMock.same((Object)torrentMock))).andReturn((Object)2);
        this.replayAll();
        int result = this.cut.getConnectingCountFor(torrentMock);
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect connecting count returned", (long)5L, (long)result);
    }

    @Test
    public void testGetConnectingCount() throws Exception {
        EasyMock.expect((Object)this.peerConnectorMockOne.getConnectingCount()).andReturn((Object)10);
        EasyMock.expect((Object)this.peerConnectorMockTwo.getConnectingCount()).andReturn((Object)5);
        this.replayAll();
        int result = this.cut.getConnectingCount();
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect sum of connecting peers", (long)15L, (long)result);
    }
}

