/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import com.jayway.awaitility.Awaitility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentHandshake;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.network.ConnectionDegradation;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.tracker.IPeerDistributor;
import org.johnnei.javatorrent.tracker.PeerConnector;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;

public class PeerConnectorTest {
    @Rule
    public Timeout timeout = Timeout.seconds((long)10L);
    private Thread workerThread;

    @Test
    public void testRun() throws Exception {
        byte[] peerId = DummyEntity.createPeerId();
        byte[] torrentHash = DummyEntity.createRandomBytes(20);
        byte[] extensionBytes = DummyEntity.createRandomBytes(8);
        Torrent torrent = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrent.getHashArray()).thenReturn((Object)torrentHash);
        torrent.addPeer((Peer)Matchers.isA(Peer.class));
        PeerConnectInfo peerConnectInfo = new PeerConnectInfo(torrent, new InetSocketAddress(InetAddress.getLocalHost(), 27960));
        ConnectionDegradation connectionDegradation = (ConnectionDegradation)Mockito.mock(ConnectionDegradation.class);
        IPeerDistributor peerDistributor = (IPeerDistributor)Mockito.mock(IPeerDistributor.class);
        TorrentClient torrentClient = (TorrentClient)Mockito.mock(TorrentClient.class);
        Mockito.when((Object)torrentClient.getConnectionDegradation()).thenReturn((Object)connectionDegradation);
        Mockito.when((Object)torrentClient.getPeerId()).thenReturn((Object)peerId);
        Mockito.when((Object)torrentClient.getExtensionBytes()).thenReturn((Object)extensionBytes);
        Mockito.when((Object)torrentClient.getPeerDistributor()).thenReturn((Object)peerDistributor);
        BitTorrentSocket socket = (BitTorrentSocket)Mockito.mock(BitTorrentSocket.class);
        socket.connect((ConnectionDegradation)Matchers.same((Object)connectionDegradation), (InetSocketAddress)Matchers.same((Object)peerConnectInfo.getAddress()));
        socket.sendHandshake(AdditionalMatchers.aryEq((byte[])extensionBytes), AdditionalMatchers.aryEq((byte[])peerId), AdditionalMatchers.aryEq((byte[])torrentHash));
        Mockito.when((Object)socket.readHandshake()).thenReturn((Object)new BitTorrentHandshake(torrentHash, extensionBytes, peerId));
        DisconnectedPeerConnector cut = new DisconnectedPeerConnector(socket, torrentClient);
        cut.enqueuePeer(peerConnectInfo);
        cut.run();
    }

    @Test
    public void testRunInterrupt() throws Exception {
        BitTorrentSocket socket = (BitTorrentSocket)Mockito.mock(BitTorrentSocket.class);
        TorrentClient torrentClient = (TorrentClient)Mockito.mock(TorrentClient.class);
        DisconnectedPeerConnector cut = new DisconnectedPeerConnector(socket, torrentClient);
        ReentrantLock lock = (ReentrantLock)Whitebox.getInternalState((Object)((Object)cut), Lock.class);
        Condition condition = (Condition)Whitebox.getInternalState((Object)((Object)cut), Condition.class);
        Thread testThread = new Thread((Runnable)((Object)cut), "Test Worker Thread");
        testThread.start();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> {
            lock.lock();
            try {
                lock.hasWaiters(condition);
            }
            finally {
                lock.unlock();
            }
        });
        testThread.interrupt();
        testThread.join(5000L);
    }

    @Test
    public void testRunWaitForSignal() throws Exception {
        BitTorrentSocket socket = (BitTorrentSocket)Mockito.mock(BitTorrentSocket.class);
        IPeerDistributor peerDistributorMock = (IPeerDistributor)Mockito.mock(IPeerDistributor.class);
        TorrentClient torrentClient = (TorrentClient)Mockito.mock(TorrentClient.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        PeerConnectInfo peerConnectInfo = new PeerConnectInfo(torrentMock, new InetSocketAddress(InetAddress.getLocalHost(), 27960));
        Mockito.when((Object)peerDistributorMock.hasReachedPeerLimit((Torrent)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)torrentClient.getPeerDistributor()).thenReturn((Object)peerDistributorMock);
        Mockito.when((Object)torrentClient.getExecutorService()).thenReturn((Object)executorServiceMock);
        DisconnectedPeerConnector cut = new DisconnectedPeerConnector(socket, torrentClient);
        ReentrantLock lock = (ReentrantLock)Whitebox.getInternalState((Object)((Object)cut), Lock.class);
        Condition condition = (Condition)Whitebox.getInternalState((Object)((Object)cut), Condition.class);
        new Thread((Runnable)((Object)cut), "Test Worker Thread").start();
        Awaitility.await().atMost(1L, TimeUnit.SECONDS).until(() -> {
            lock.lock();
            try {
                lock.hasWaiters(condition);
            }
            finally {
                lock.unlock();
            }
        });
        cut.enqueuePeer(peerConnectInfo);
        Awaitility.await().atMost(3L, TimeUnit.SECONDS).until(() -> cut.getConnectingCount() == 0);
    }

    @Test
    public void testRunPeerDistributorDecline() throws Exception {
        BitTorrentSocket socket = (BitTorrentSocket)Mockito.mock(BitTorrentSocket.class);
        IPeerDistributor peerDistributorMock = (IPeerDistributor)Mockito.mock(IPeerDistributor.class);
        TorrentClient torrentClient = (TorrentClient)Mockito.mock(TorrentClient.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
        PeerConnectInfo peerConnectInfo = new PeerConnectInfo(torrentMock, new InetSocketAddress(InetAddress.getLocalHost(), 27960));
        Mockito.when((Object)peerDistributorMock.hasReachedPeerLimit((Torrent)Matchers.any())).thenReturn((Object)true);
        Mockito.when((Object)torrentClient.getPeerDistributor()).thenReturn((Object)peerDistributorMock);
        Mockito.when((Object)torrentClient.getExecutorService()).thenReturn((Object)executorServiceMock);
        DisconnectedPeerConnector cut = new DisconnectedPeerConnector(socket, torrentClient);
        cut.enqueuePeer(peerConnectInfo);
        cut.run();
        ArgumentCaptor runnableCapture = ArgumentCaptor.forClass(Runnable.class);
        ((ScheduledExecutorService)Mockito.verify((Object)executorServiceMock)).schedule((Runnable)runnableCapture.capture(), Matchers.eq((long)10L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.SECONDS))));
        Assert.assertEquals((String)"Peer connector queue must be empty", (long)0L, (long)cut.getConnectingCount());
        ((Runnable)runnableCapture.getValue()).run();
        Assert.assertEquals((String)"Peer connector queue must not be empty", (long)1L, (long)cut.getConnectingCount());
    }

    @Test
    public void testRunUnknownTorrent() throws Exception {
        byte[] peerId = DummyEntity.createPeerId();
        byte[] torrentHash = DummyEntity.createRandomBytes(20);
        byte[] torrentHashTwo = DummyEntity.createRandomBytes(20);
        while (Arrays.equals(torrentHash, torrentHashTwo)) {
            torrentHashTwo = DummyEntity.createRandomBytes(20);
        }
        byte[] extensionBytes = DummyEntity.createRandomBytes(8);
        Torrent torrent = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrent.getHashArray()).thenReturn((Object)torrentHash);
        PeerConnectInfo peerConnectInfo = new PeerConnectInfo(torrent, new InetSocketAddress(InetAddress.getLocalHost(), 27960));
        ConnectionDegradation connectionDegradation = (ConnectionDegradation)Mockito.mock(ConnectionDegradation.class);
        IPeerDistributor peerDistributor = (IPeerDistributor)Mockito.mock(IPeerDistributor.class);
        TorrentClient torrentClient = (TorrentClient)Mockito.mock(TorrentClient.class);
        Mockito.when((Object)torrentClient.getConnectionDegradation()).thenReturn((Object)connectionDegradation);
        Mockito.when((Object)torrentClient.getPeerId()).thenReturn((Object)peerId);
        Mockito.when((Object)torrentClient.getExtensionBytes()).thenReturn((Object)extensionBytes);
        Mockito.when((Object)torrentClient.getPeerDistributor()).thenReturn((Object)peerDistributor);
        BitTorrentSocket socket = (BitTorrentSocket)Mockito.mock(BitTorrentSocket.class);
        socket.connect((ConnectionDegradation)Matchers.same((Object)connectionDegradation), (InetSocketAddress)Matchers.same((Object)peerConnectInfo.getAddress()));
        socket.sendHandshake(AdditionalMatchers.aryEq((byte[])extensionBytes), AdditionalMatchers.aryEq((byte[])peerId), AdditionalMatchers.aryEq((byte[])torrentHash));
        Mockito.when((Object)socket.readHandshake()).thenReturn((Object)new BitTorrentHandshake(torrentHashTwo, extensionBytes, peerId));
        socket.close();
        DisconnectedPeerConnector cut = new DisconnectedPeerConnector(socket, torrentClient);
        cut.enqueuePeer(peerConnectInfo);
        cut.run();
    }

    @Test
    public void testGetConnectingCount() throws Exception {
        byte[] torrentHash = DummyEntity.createRandomBytes(20);
        byte[] torrentHashTwo = DummyEntity.createRandomBytes(20);
        while (Arrays.equals(torrentHash, torrentHashTwo)) {
            torrentHashTwo = DummyEntity.createRandomBytes(20);
        }
        TorrentClient torrentClient = (TorrentClient)Mockito.mock(TorrentClient.class);
        Torrent torrent = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrent.getHashArray()).thenReturn((Object)torrentHash);
        Torrent torrentTwo = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrentTwo.getHashArray()).thenReturn((Object)torrentHashTwo);
        PeerConnector cut = new PeerConnector(torrentClient);
        PeerConnectInfo peerConnectInfo = new PeerConnectInfo(torrent, new InetSocketAddress(InetAddress.getLocalHost(), 27960));
        cut.enqueuePeer(null);
        Assert.assertEquals((String)"Incorrect connecting count", (long)0L, (long)cut.getConnectingCount());
        cut.enqueuePeer(peerConnectInfo);
        Assert.assertEquals((String)"Incorrect connecting count", (long)1L, (long)cut.getConnectingCount());
        Assert.assertEquals((String)"Incorrect connecting count", (long)1L, (long)cut.getConnectingCountFor(torrent));
        Assert.assertEquals((String)"Incorrect connecting count", (long)0L, (long)cut.getConnectingCountFor(torrentTwo));
    }

    @Test
    public void testRunIOException() throws Exception {
        byte[] torrentHash = DummyEntity.createRandomBytes(20);
        Torrent torrent = (Torrent)Mockito.mock(Torrent.class);
        Mockito.when((Object)torrent.getHashArray()).thenReturn((Object)torrentHash);
        PeerConnectInfo peerConnectInfo = new PeerConnectInfo(torrent, new InetSocketAddress(InetAddress.getLocalHost(), 27960));
        ConnectionDegradation connectionDegradation = (ConnectionDegradation)Mockito.mock(ConnectionDegradation.class);
        IPeerDistributor peerDistributor = (IPeerDistributor)Mockito.mock(IPeerDistributor.class);
        TorrentClient torrentClient = (TorrentClient)Mockito.mock(TorrentClient.class);
        Mockito.when((Object)torrentClient.getConnectionDegradation()).thenReturn((Object)connectionDegradation);
        Mockito.when((Object)torrentClient.getPeerDistributor()).thenReturn((Object)peerDistributor);
        BitTorrentSocket socket = (BitTorrentSocket)Mockito.mock(BitTorrentSocket.class);
        ((BitTorrentSocket)Mockito.doThrow((Throwable)new IOException("Dummy exception!")).when((Object)socket)).connect((ConnectionDegradation)Matchers.same((Object)connectionDegradation), (InetSocketAddress)Matchers.same((Object)peerConnectInfo.getAddress()));
        DisconnectedPeerConnector cut = new DisconnectedPeerConnector(socket, torrentClient);
        cut.enqueuePeer(peerConnectInfo);
        cut.run();
    }

    @Test
    public void testStartStop() throws Exception {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        PeerConnector connector = new PeerConnector(null){

            public void run() {
                PeerConnectorTest.this.workerThread = Thread.currentThread();
                countDownLatch.countDown();
            }
        };
        connector.start();
        if (!countDownLatch.await(5L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Thread did not start");
        }
        connector.stop();
        this.workerThread.join(5000L);
        Assert.assertFalse((String)"Thread should have died by now.", (boolean)this.workerThread.isAlive());
    }

    private class DisconnectedPeerConnector
    extends PeerConnector {
        private BitTorrentSocket socket;

        public DisconnectedPeerConnector(BitTorrentSocket socket, TorrentClient torrentClient) {
            super(torrentClient);
            this.socket = socket;
        }

        BitTorrentSocket createUnconnectedSocket() {
            return this.socket;
        }
    }
}

