/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.async;

import org.johnnei.javatorrent.utils.Argument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopingRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopingRunnable.class);
    private final Runnable runnable;
    private boolean keepRunning;

    public LoopingRunnable(Runnable runnable) {
        this.runnable = Argument.requireNonNull(runnable, "Runnable not cannot be null");
        this.keepRunning = true;
    }

    public void stop() {
        this.keepRunning = false;
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            this.runnable.run();
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                LOGGER.trace("Ignoring interrupted exception for endless looping task.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

