/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedString;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;

public class BencodedMap
extends AbstractBencodedValue {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private Map<String, IBencodedValue> map = new HashMap<String, IBencodedValue>();

    public void put(String name, IBencodedValue value) {
        this.map.put(name, value);
    }

    public Optional<IBencodedValue> get(String name) {
        return Optional.ofNullable(this.map.get(name));
    }

    public Optional<IBencodedValue> remove(String name) {
        return Optional.ofNullable(this.map.remove(name));
    }

    @Override
    public Map<String, IBencodedValue> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public String serialize() {
        TreeMap<String, IBencodedValue> sortedMap = new TreeMap<String, IBencodedValue>(new RawStringComparator());
        sortedMap.putAll(this.map);
        StringBuilder bencoded = new StringBuilder("d");
        for (Map.Entry entry : sortedMap.entrySet()) {
            bencoded.append(new BencodedString((String)entry.getKey()).serialize());
            bencoded.append(((IBencodedValue)entry.getValue()).serialize());
        }
        bencoded.append("e");
        return bencoded.toString();
    }

    private static class RawStringComparator
    implements Comparator<String> {
        private RawStringComparator() {
        }

        @Override
        public int compare(String a, String b) {
            byte[] bBytes;
            byte[] aBytes = a.getBytes(UTF8);
            int lengthCompare = Integer.compare(aBytes.length, (bBytes = b.getBytes(UTF8)).length);
            if (lengthCompare != 0) {
                return lengthCompare;
            }
            for (int i = 0; i < aBytes.length; ++i) {
                if (aBytes[i] == bBytes[i]) continue;
                if (aBytes[i] > bBytes[i]) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }
}

