/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import org.johnnei.javatorrent.bittorrent.encoding.AbstractBencodedValue;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedInteger;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedList;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedMap;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedString;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;

public class Bencoding {
    private int charactersRead;

    public IBencodedValue decode(Reader reader) {
        try {
            this.charactersRead = 0;
            return this.decodeNextValue(reader);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to decode bencoded values.", e);
        }
    }

    public int getCharactersRead() {
        return this.charactersRead;
    }

    private IBencodedValue decodeNextValue(Reader reader) throws IOException {
        char token = this.peekCharacter(reader);
        AbstractBencodedValue value = 'i' == token ? this.decodeInteger(reader) : ('l' == token ? this.decodeList(reader) : ('d' == token ? this.decodeMap(reader) : this.decodeString(reader)));
        return value;
    }

    private BencodedList decodeList(Reader reader) throws IOException {
        this.consumeToken('l', reader);
        BencodedList list = new BencodedList();
        char token = this.peekCharacter(reader);
        while ('e' != token) {
            list.add(this.decodeNextValue(reader));
            token = this.peekCharacter(reader);
        }
        this.consumeToken('e', reader);
        return list;
    }

    private BencodedString decodeString(Reader reader) throws IOException {
        int read;
        StringBuilder length = new StringBuilder();
        char token = this.peekCharacter(reader);
        while (':' != token) {
            length.append(this.readCharacter(reader));
            token = this.peekCharacter(reader);
        }
        this.consumeToken(':', reader);
        char[] characters = new char[Integer.parseInt(length.toString())];
        int totalRead = 0;
        do {
            if ((read = reader.read(characters, totalRead, characters.length - totalRead)) <= 0) {
                throw new IOException("Failed to read string");
            }
            this.charactersRead += read;
        } while ((totalRead += read) != characters.length);
        return new BencodedString(new String(characters));
    }

    private BencodedMap decodeMap(Reader reader) throws IOException {
        BencodedMap map = new BencodedMap();
        this.consumeToken('d', reader);
        char nextToken = this.peekCharacter(reader);
        while ('e' != nextToken) {
            BencodedString key = this.decodeString(reader);
            IBencodedValue value = this.decodeNextValue(reader);
            map.put(key.asString(), value);
            nextToken = this.peekCharacter(reader);
        }
        this.consumeToken('e', reader);
        return map;
    }

    private BencodedInteger decodeInteger(Reader reader) throws IOException {
        this.consumeToken('i', reader);
        StringBuilder integer = new StringBuilder();
        char nextToken = this.peekCharacter(reader);
        while ('e' != nextToken) {
            integer.append(this.readCharacter(reader));
            nextToken = this.peekCharacter(reader);
        }
        this.consumeToken('e', reader);
        return new BencodedInteger(new BigInteger(integer.toString()));
    }

    private char readCharacter(Reader reader) throws IOException {
        int character = reader.read();
        if (character == -1) {
            throw new IOException("End of Stream reached");
        }
        ++this.charactersRead;
        return (char)character;
    }

    private char peekCharacter(Reader reader) throws IOException {
        reader.mark(1);
        char result = (char)reader.read();
        reader.reset();
        return result;
    }

    private void consumeToken(char token, Reader reader) throws IOException {
        char readToken = this.readCharacter(reader);
        if (token != readToken) {
            throw new IOException(String.format("Incorrect token consumed, expected '%s' but read '%s'", Character.valueOf(token), Character.valueOf(readToken)));
        }
    }
}

