/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import org.johnnei.javatorrent.internal.bittorrent.protocol.messages.AbstractBlockMessage;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageRequest
extends AbstractBlockMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageRequest.class);

    public MessageRequest() {
    }

    public MessageRequest(int index, int offset, int length) {
        this.index = index;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void process(Peer peer) {
        if (peer.getTorrent().getFileSet().hasPiece(this.index)) {
            peer.addBlockRequest(this.index, this.offset, this.length, PeerDirection.Upload);
        } else {
            LOGGER.error("Requested piece {} which I don't have", (Object)this.index);
            peer.getBitTorrentSocket().close();
        }
    }

    @Override
    public int getId() {
        return 6;
    }

    public String toString() {
        return String.format("MessageRequest[index=%d, offset=%d, lenght=%d]", this.index, this.offset, this.length);
    }
}

