/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.disk;

import java.io.IOException;
import java.util.Objects;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DiskJobWrapper
implements Comparable<DiskJobWrapper> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskJobWrapper.class);
    private final IDiskJob diskJob;
    private int attempt;

    DiskJobWrapper(IDiskJob diskJob) {
        this.diskJob = Objects.requireNonNull(diskJob, "Can't wrap a null-job");
    }

    public boolean process() {
        try {
            this.diskJob.process();
            return true;
        }
        catch (IOException e) {
            ++this.attempt;
            LOGGER.warn("Failed to process {}. (Attempt: {})", new Object[]{this.diskJob, this.attempt, e});
            return false;
        }
    }

    @Override
    public int compareTo(DiskJobWrapper o) {
        return this.diskJob.getPriority() - o.diskJob.getPriority();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DiskJobWrapper)) {
            return false;
        }
        DiskJobWrapper other = (DiskJobWrapper)obj;
        return Objects.equals(this.diskJob, other.diskJob);
    }

    public String toString() {
        return String.format("DiskJobWrapper[value=%s]", this.diskJob);
    }

    public int hashCode() {
        return this.diskJob.hashCode();
    }
}

