/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.internal.network.PeerIoRunnable;
import org.johnnei.javatorrent.internal.torrent.TorrentProcessor;
import org.johnnei.javatorrent.network.TcpPeerConnectionAcceptor;
import org.johnnei.javatorrent.torrent.Torrent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorrentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentManager.class);
    private final Object torrentListLock = new Object();
    private TorrentClient torrentClient;
    private List<TorrentPair> activeTorrents = new ArrayList<TorrentPair>();
    private LoopingRunnable connectorRunnable;
    private LoopingRunnable peerIoRunnable;

    public void start(TorrentClient torrentClient) {
        this.torrentClient = torrentClient;
        this.peerIoRunnable = new LoopingRunnable(new PeerIoRunnable(this));
        Thread thread = new Thread((Runnable)this.peerIoRunnable, "Peer IO");
        thread.setDaemon(true);
        thread.start();
    }

    public void enableConnectionAcceptor() {
        try {
            this.connectorRunnable = new LoopingRunnable(new TcpPeerConnectionAcceptor(this.torrentClient));
            Thread connectorThread = new Thread((Runnable)this.connectorRunnable, "Connection Acceptor");
            connectorThread.setDaemon(true);
            connectorThread.start();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to start connection acceptor", (Throwable)e);
        }
    }

    public void stop() {
        this.peerIoRunnable.stop();
        if (this.connectorRunnable != null) {
            this.connectorRunnable.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTorrent(Torrent torrent) {
        Object object = this.torrentListLock;
        synchronized (object) {
            this.activeTorrents.add(new TorrentPair(this, this.torrentClient, torrent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTorrent(Torrent torrent) {
        Object object = this.torrentListLock;
        synchronized (object) {
            this.activeTorrents.removeIf(torrentPair -> torrentPair.getTorrent().equals(torrent));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownTorrent(Torrent torrent) {
        Optional<TorrentPair> pair;
        Object object = this.torrentListLock;
        synchronized (object) {
            pair = this.activeTorrents.stream().filter(torrentPair -> torrentPair.getTorrent().equals(torrent)).findAny();
            if (pair.isPresent()) {
                this.activeTorrents.remove(pair.get());
            }
        }
        if (pair.isPresent()) {
            pair.get().getTorrentProcessor().shutdownTorrent();
        }
    }

    public Optional<Torrent> getTorrent(byte[] hash) {
        return this.activeTorrents.stream().map(TorrentPair::getTorrent).filter(torrent -> Arrays.equals(torrent.getHashArray(), hash)).findAny();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Torrent> getTorrents() {
        Object object = this.torrentListLock;
        synchronized (object) {
            return this.activeTorrents.stream().map(TorrentPair::getTorrent).collect(Collectors.toList());
        }
    }

    private final class TorrentPair {
        private final Torrent torrent;
        private final TorrentProcessor torrentProcessor;

        TorrentPair(TorrentManager torrentManager2, TorrentClient torrentClient, Torrent torrent) {
            this.torrent = torrent;
            this.torrentProcessor = new TorrentProcessor(torrentManager2, torrentClient, torrent);
        }

        public Torrent getTorrent() {
            return this.torrent;
        }

        public TorrentProcessor getTorrentProcessor() {
            return this.torrentProcessor;
        }
    }
}

