/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.johnnei.javatorrent.internal.utils.CheckedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutStream.class);
    private ByteArrayOutputStream buffer;
    private DataOutputStream out;

    public OutStream() {
        this(32);
    }

    public OutStream(int size) {
        this.buffer = new ByteArrayOutputStream(size);
        this.out = new DataOutputStream(this.buffer);
    }

    public void write(byte[] b) {
        this.writeUnchecked(() -> this.out.write(b));
    }

    public void write(byte[] b, int off, int len) {
        this.writeUnchecked(() -> this.out.write(b, off, len));
    }

    public void writeBoolean(boolean v) {
        this.writeUnchecked(() -> this.out.writeBoolean(v));
    }

    public void writeByte(int v) {
        this.writeUnchecked(() -> this.out.writeByte(v));
    }

    public void writeInt(int v) {
        this.writeUnchecked(() -> this.out.writeInt(v));
    }

    public void writeLong(long v) {
        this.writeUnchecked(() -> this.out.writeLong(v));
    }

    public void writeShort(int v) {
        this.writeUnchecked(() -> this.out.writeShort(v));
    }

    public void writeString(String s) {
        this.write(s.getBytes(Charset.forName("UTF-8")));
    }

    public int size() {
        return this.buffer.size();
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    private void writeUnchecked(CheckedRunnable<IOException> writeCall) {
        try {
            writeCall.run();
        }
        catch (IOException e) {
            LOGGER.error("Somehow you managed to get an IO exception on a byte array. I'm proud.", (Throwable)e);
            throw new RuntimeException("IO Exception on in-memory byte array.", e);
        }
    }
}

