/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedList;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedMap;
import org.johnnei.javatorrent.bittorrent.encoding.Bencoding;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.johnnei.javatorrent.internal.network.ByteInputStream;
import org.johnnei.javatorrent.internal.torrent.peer.Bitfield;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.utils.Argument;
import org.johnnei.javatorrent.utils.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TorrentFileSet
extends AbstractFileSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(TorrentFileSet.class);
    private static final int BLOCK_SIZE = 16384;
    private static final String ERR_INCOMPLETE_INFO_ENTRY = "Metadata file appears to be validly encoded but is missing critical information from the 'info' entry.";
    private Bencoding bencoding = new Bencoding();
    private File downloadFolder;
    private int pieceSize;
    private Bitfield bitfield;

    public TorrentFileSet(File torrentFile, File downloadFolder) {
        super(16384);
        Argument.requireNonNull(torrentFile, "Torrent file can not be null");
        if (!torrentFile.exists()) {
            throw new IllegalArgumentException(String.format("Torrent file (%s) does not exist.", torrentFile.getAbsolutePath()));
        }
        this.downloadFolder = Argument.requireNonNull(downloadFolder, "Download folder cannot be null");
        this.parseTorrentFileData(torrentFile);
        this.bitfield = new Bitfield(this.getBitfieldSize());
    }

    private void parseTorrentFileData(File torrentFile) {
        try (ByteInputStream in = new ByteInputStream(new FileInputStream(torrentFile));){
            BencodedMap metadataInfo = (BencodedMap)this.bencoding.decode(new StringReader(in.readString(in.available())));
            if (!this.isInfoDirectory(metadataInfo.asMap()) && !this.isInfoDirectory((metadataInfo = (BencodedMap)metadataInfo.get("info").orElseThrow(() -> new IllegalArgumentException(ERR_INCOMPLETE_INFO_ENTRY))).asMap())) {
                throw new IllegalArgumentException(ERR_INCOMPLETE_INFO_ENTRY);
            }
            this.parseDictionary(metadataInfo);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to parse torrent data.", (Throwable)e);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LOGGER.trace("Got interrupted while parsing torrent information.", (Throwable)ex);
            }
            this.parseTorrentFileData(torrentFile);
        }
    }

    private void parseDictionary(BencodedMap dictionary) {
        dictionary.get("name").ifPresent(name -> {
            this.downloadFolder = new File(this.downloadFolder, name.asString());
        });
        if (!this.downloadFolder.exists() && !this.downloadFolder.mkdirs()) {
            throw new IllegalStateException(String.format("Failed to create download folder: %s", this.downloadFolder.getAbsolutePath()));
        }
        this.pieceSize = (int)dictionary.get("piece length").get().asLong();
        long remainingSize = 0L;
        Optional<IBencodedValue> filesEntry = dictionary.get("files");
        if (filesEntry.isPresent()) {
            List<IBencodedValue> files = filesEntry.get().asList();
            this.fileInfos = new ArrayList(files.size());
            for (IBencodedValue fileEntry : files) {
                BencodedMap file = (BencodedMap)fileEntry;
                long fileSize = file.get("length").get().asLong();
                BencodedList fileStructure = (BencodedList)file.get("path").get();
                String fileName = "";
                if (fileStructure.size() > 1) {
                    for (int j = 0; j < fileStructure.size(); ++j) {
                        fileName = fileName + "/" + fileStructure.get(j);
                    }
                } else {
                    fileName = fileStructure.get(0).asString();
                }
                int pieceCount = (int)MathUtils.ceilDivision(fileSize, this.pieceSize);
                if (remainingSize % (long)this.pieceSize != 0L && fileSize >= (long)this.pieceSize) {
                    ++pieceCount;
                }
                FileInfo info = new FileInfo(fileSize, remainingSize, this.getFile(fileName), pieceCount);
                this.fileInfos.add(info);
                remainingSize += fileSize;
            }
        } else {
            this.fileInfos = new ArrayList(1);
            String filename = dictionary.get("name").get().asString();
            long fileSize = dictionary.get("length").get().asLong();
            this.fileInfos.add(new FileInfo(fileSize, remainingSize, this.getFile(filename), (int)MathUtils.ceilDivision(fileSize, this.pieceSize)));
            remainingSize += fileSize;
        }
        String pieceHashes = dictionary.get("pieces").get().asString();
        int pieceAmount = pieceHashes.length() / 20;
        this.pieces = new ArrayList(pieceAmount);
        for (int index = 0; index < pieceAmount; ++index) {
            int hashOffset = index * 20;
            int size = (int)Math.min((long)this.pieceSize, remainingSize);
            byte[] sha1Hash = new byte[20];
            char[] hashBytes = pieceHashes.substring(hashOffset, hashOffset + 20).toCharArray();
            for (int i = 0; i < sha1Hash.length; ++i) {
                sha1Hash[i] = (byte)hashBytes[i];
            }
            this.pieces.add(new Piece(this, sha1Hash, index, size, 16384));
            remainingSize -= (long)size;
        }
    }

    private boolean isInfoDirectory(Map<String, IBencodedValue> metadata) {
        if (!metadata.containsKey("length") && !metadata.containsKey("files")) {
            return false;
        }
        if (!metadata.containsKey("pieces")) {
            return false;
        }
        return metadata.containsKey("piece length");
    }

    @Override
    public void setHavingPiece(int pieceIndex) {
        super.setHavingPiece(pieceIndex);
        this.bitfield.havePiece(pieceIndex);
    }

    private int getBitfieldSize() {
        return (int)Math.ceil((double)this.pieces.size() / 8.0);
    }

    private File getFile(String name) {
        return new File(this.downloadFolder, name);
    }

    @Override
    public long getPieceSize() {
        return this.pieceSize;
    }

    @Override
    public byte[] getBitfieldBytes() throws UnsupportedOperationException {
        return this.bitfield.getBytes();
    }
}

