/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.tracker;

import java.util.LinkedList;
import java.util.List;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.network.PeerConnectInfo;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.IPeerConnector;
import org.johnnei.javatorrent.tracker.PeerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnectorPool
implements IPeerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnectorPool.class);
    private List<IPeerConnector> connectors = new LinkedList<IPeerConnector>();

    public PeerConnectorPool(TorrentClient torrentClient, int maxConcurrentConnecting) {
        LOGGER.info("Starting PeerConnector pool with {} connectors.", (Object)maxConcurrentConnecting);
        for (int i = 0; i < maxConcurrentConnecting; ++i) {
            this.connectors.add(new PeerConnector(torrentClient));
        }
    }

    @Override
    public void start() {
        this.connectors.forEach(IPeerConnector::start);
    }

    @Override
    public void stop() {
        this.connectors.forEach(IPeerConnector::stop);
    }

    @Override
    public void enqueuePeer(PeerConnectInfo peer) {
        IPeerConnector connector = (IPeerConnector)this.connectors.stream().min((a, b) -> a.getConnectingCount() - b.getConnectingCount()).get();
        connector.enqueuePeer(peer);
    }

    @Override
    public int getConnectingCount() {
        return this.connectors.stream().mapToInt(IPeerConnector::getConnectingCount).sum();
    }

    @Override
    public int getConnectingCountFor(Torrent torrent) {
        return this.connectors.stream().mapToInt(c -> c.getConnectingCountFor(torrent)).sum();
    }
}

