/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent;

import java.util.Collections;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.internal.disk.IOManager;
import org.johnnei.javatorrent.internal.torrent.TorrentManager;
import org.johnnei.javatorrent.module.IModule;
import org.johnnei.javatorrent.network.ConnectionDegradation;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.phases.PhaseRegulator;
import org.johnnei.javatorrent.test.TestUtils;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.tracker.IPeerConnector;
import org.johnnei.javatorrent.tracker.IPeerDistributor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.reflect.Whitebox;

@RunWith(value=EasyMockRunner.class)
public class TorrentClientTest
extends EasyMockSupport {
    @Test
    public void testBuilder() throws Exception {
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IPeerConnector peerConnectorMock = (IPeerConnector)this.createMock(IPeerConnector.class);
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        IMessage messageMock = (IMessage)this.createMock(IMessage.class);
        IModule moduleMock = (IModule)this.createMock(IModule.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        IDownloadPhase phaseMock = (IDownloadPhase)this.createMock(IDownloadPhase.class);
        IPeerDistributor peerDistributorMock = (IPeerDistributor)this.createMock(IPeerDistributor.class);
        peerConnectorMock.start();
        TorrentClient.Builder builder = new TorrentClient.Builder();
        trackerMock.addTorrent((Torrent)EasyMock.same((Object)torrentMock));
        EasyMock.expect((Object)moduleMock.getDependsOn()).andReturn(Collections.emptyList());
        EasyMock.expect((Object)moduleMock.getRelatedBep()).andReturn((Object)3);
        moduleMock.configureTorrentClient((TorrentClient.Builder)EasyMock.same((Object)builder));
        moduleMock.onBuild((TorrentClient)EasyMock.notNull());
        EasyMock.expect((Object)phaseRegulatorMock.createInitialPhase((TorrentClient)EasyMock.notNull(), (Torrent)EasyMock.notNull())).andReturn((Object)phaseMock);
        phaseMock.onPhaseEnter();
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.notNull()))).andReturn(null).times(4);
        this.replayAll();
        TorrentClient torrentClient = builder.setConnectionDegradation(connectionDegradationMock).setPeerDistributor(tc -> peerDistributorMock).setPhaseRegulator(phaseRegulatorMock).setExecutorService(executorServiceMock).setPeerConnector(t -> peerConnectorMock).registerTrackerProtocol("udp", (url, client) -> trackerMock).registerMessage(15, () -> messageMock).registerModule(moduleMock).setDownloadPort(27960).build();
        torrentClient.download(torrentMock, Collections.singleton("udp://localhost:80"));
        this.verifyAll();
        Assert.assertEquals((String)"Incorrect connection degradation instance", (Object)connectionDegradationMock, (Object)torrentClient.getConnectionDegradation());
        Assert.assertEquals((String)"Incorrect phase regulator instance", (Object)phaseRegulatorMock, (Object)torrentClient.getPhaseRegulator());
        Assert.assertEquals((String)"Incorrect executor service instance", (Object)executorServiceMock, (Object)torrentClient.getExecutorService());
        Assert.assertEquals((String)"Incorrect peer connector instance", (Object)peerConnectorMock, (Object)torrentClient.getPeerConnector());
        Assert.assertEquals((String)"Incorrect peer distributor instance", (Object)peerDistributorMock, (Object)torrentClient.getPeerDistributor());
        Assert.assertEquals((String)"Incorrect download port", (long)27960L, (long)torrentClient.getDownloadPort());
        for (int i = 0; i < 8; ++i) {
            Assert.assertNotNull((String)String.format("Missing message: %d", i), (Object)torrentClient.getMessageFactory().createById(i));
        }
        Assert.assertNotNull((String)"Missing message: 15", (Object)torrentClient.getMessageFactory().createById(15));
        byte[] peerId = torrentClient.getPeerId();
        String clientIdentifier = new String(peerId, 0, 8);
        Assert.assertTrue((String)("Incorrect client identifier in peer ID: " + clientIdentifier), (boolean)Pattern.matches("-JT\\d{4}-", clientIdentifier));
        TestUtils.assertPresent("Missing module", torrentClient.getModule(moduleMock.getClass()));
        Assert.assertTrue((String)"Missing module", (boolean)torrentClient.getModules().contains(moduleMock));
    }

    @Test(expected=IllegalStateException.class)
    public void testRegisterModuleMissingDependency() {
        IModule moduleMock = (IModule)this.createMock(IModule.class);
        EasyMock.expect((Object)moduleMock.getDependsOn()).andReturn(Collections.singletonList(IModule.class));
        this.replayAll();
        new TorrentClient.Builder().registerModule(moduleMock);
        this.verifyAll();
    }

    @Test
    public void testGetExtensionBytesEnableSpecificBit() throws Exception {
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IPeerConnector peerConnectorMock = (IPeerConnector)this.createMock(IPeerConnector.class);
        IPeerDistributor peerDistributor = (IPeerDistributor)this.createMock(IPeerDistributor.class);
        peerConnectorMock.start();
        this.replayAll();
        TorrentClient torrentClient = new TorrentClient.Builder().setConnectionDegradation(connectionDegradationMock).setPhaseRegulator(phaseRegulatorMock).setExecutorService(executorServiceMock).setPeerConnector(t -> peerConnectorMock).setPeerDistributor(tc -> peerDistributor).registerTrackerProtocol("udp", (url, client) -> null).enableExtensionBit(20).build();
        this.verifyAll();
        byte[] extensionBytes = torrentClient.getExtensionBytes();
        byte[] expectedBytes = new byte[]{0, 0, 0, 0, 0, 16, 0, 0};
        Assert.assertEquals((String)"Incorrect amount of extension byes", (long)8L, (long)extensionBytes.length);
        Assert.assertArrayEquals((String)"Extension bit didn't get enabled correctly", (byte[])expectedBytes, (byte[])extensionBytes);
    }

    @Test
    public void testGetExtensionBytesEnableAllBits() throws Exception {
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IPeerConnector peerConnectorMock = (IPeerConnector)this.createMock(IPeerConnector.class);
        IPeerDistributor peerDistributorMock = (IPeerDistributor)this.createMock(IPeerDistributor.class);
        peerConnectorMock.start();
        this.replayAll();
        TorrentClient.Builder builder = new TorrentClient.Builder().setConnectionDegradation(connectionDegradationMock).setPhaseRegulator(phaseRegulatorMock).setExecutorService(executorServiceMock).setPeerConnector(t -> peerConnectorMock).setPeerDistributor(tc -> peerDistributorMock).registerTrackerProtocol("udp", (url, client) -> null);
        for (int i = 0; i < 64; ++i) {
            builder.enableExtensionBit(i);
        }
        byte[] extensionBytes = builder.build().getExtensionBytes();
        this.verifyAll();
        byte[] expectedBytes = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        Assert.assertEquals((String)"Incorrect amount of extension byes", (long)8L, (long)extensionBytes.length);
        Assert.assertArrayEquals((String)"Extension bit didn't get enabled correctly", (byte[])expectedBytes, (byte[])extensionBytes);
    }

    @Test
    public void testCreateUniqueTransactionId() throws Exception {
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IPeerConnector peerConnectorMock = (IPeerConnector)this.createMock(IPeerConnector.class);
        IPeerDistributor peerDistributorMock = (IPeerDistributor)this.createMock(IPeerDistributor.class);
        peerConnectorMock.start();
        this.replayAll();
        TorrentClient cut = new TorrentClient.Builder().setConnectionDegradation(connectionDegradationMock).setPhaseRegulator(phaseRegulatorMock).setExecutorService(executorServiceMock).setPeerConnector(t -> peerConnectorMock).setPeerDistributor(tc -> peerDistributorMock).registerTrackerProtocol("udp", (url, client) -> null).build();
        int id = cut.createUniqueTransactionId();
        int id2 = cut.createUniqueTransactionId();
        Assert.assertNotEquals((String)"Duplicate transaction IDs", (long)id, (long)id2);
    }

    @Test
    public void testShutdown() throws Exception {
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IPeerConnector peerConnectorMock = (IPeerConnector)this.createMock(IPeerConnector.class);
        IPeerDistributor peerDistributorMock = (IPeerDistributor)this.createMock(IPeerDistributor.class);
        IModule moduleMock = (IModule)this.createMock(IModule.class);
        moduleMock.configureTorrentClient((TorrentClient.Builder)EasyMock.anyObject());
        moduleMock.onBuild((TorrentClient)EasyMock.anyObject());
        moduleMock.onShutdown();
        EasyMock.expect((Object)moduleMock.getDependsOn()).andReturn(Collections.emptyList());
        EasyMock.expect((Object)moduleMock.getRelatedBep()).andReturn((Object)3);
        peerConnectorMock.start();
        peerConnectorMock.stop();
        executorServiceMock.shutdown();
        this.replayAll();
        TorrentClient cut = new TorrentClient.Builder().setConnectionDegradation(connectionDegradationMock).setPhaseRegulator(phaseRegulatorMock).setExecutorService(executorServiceMock).setPeerConnector(t -> peerConnectorMock).setPeerDistributor(tc -> peerDistributorMock).registerTrackerProtocol("udp", (url, client) -> null).registerModule(moduleMock).build();
        TorrentManager torrentManager = (TorrentManager)Whitebox.getInternalState((Object)cut, TorrentManager.class);
        LoopingRunnable peerIoRunnable = (LoopingRunnable)Whitebox.getInternalState((Object)torrentManager, (String)"peerIoRunnable");
        Assert.assertTrue((String)"Peer IO should have been invoked to start", (boolean)((Boolean)Whitebox.getInternalState((Object)peerIoRunnable, (String)"keepRunning")));
        cut.shutdown();
        Assert.assertFalse((String)"Peer IO should have been invoked to start", (boolean)((Boolean)Whitebox.getInternalState((Object)peerIoRunnable, (String)"keepRunning")));
        this.verifyAll();
    }

    @Test
    public void testAddDiskJob() throws Exception {
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IPeerConnector peerConnectorMock = (IPeerConnector)this.createMock(IPeerConnector.class);
        IPeerDistributor peerDistributor = (IPeerDistributor)this.createMock(IPeerDistributor.class);
        IOManager ioManagerMock = (IOManager)this.createMock(IOManager.class);
        IDiskJob diskJobMock = (IDiskJob)this.createMock(IDiskJob.class);
        peerConnectorMock.start();
        ioManagerMock.addTask((IDiskJob)EasyMock.same((Object)diskJobMock));
        this.replayAll();
        TorrentClient cut = new TorrentClient.Builder().setConnectionDegradation(connectionDegradationMock).setPhaseRegulator(phaseRegulatorMock).setExecutorService(executorServiceMock).setPeerConnector(t -> peerConnectorMock).setPeerDistributor(tc -> peerDistributor).registerTrackerProtocol("udp", (url, client) -> null).build();
        Whitebox.setInternalState((Object)cut, (Object)ioManagerMock, (Object[])new Object[0]);
        cut.addDiskJob(diskJobMock);
        this.verifyAll();
    }

    @Test
    public void testAcceptIncomingConnections() throws Exception {
        ConnectionDegradation connectionDegradationMock = (ConnectionDegradation)this.createMock(ConnectionDegradation.class);
        PhaseRegulator phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IPeerConnector peerConnectorMock = (IPeerConnector)this.createMock(IPeerConnector.class);
        IPeerDistributor peerDistributorMock = (IPeerDistributor)this.createMock(IPeerDistributor.class);
        peerConnectorMock.start();
        this.replayAll();
        TorrentClient cut = new TorrentClient.Builder().setConnectionDegradation(connectionDegradationMock).setPhaseRegulator(phaseRegulatorMock).setExecutorService(executorServiceMock).setPeerConnector(t -> peerConnectorMock).setPeerDistributor(tc -> peerDistributorMock).registerTrackerProtocol("udp", (url, client) -> null).acceptIncomingConnections(true).build();
        this.verifyAll();
        TorrentManager torrentManager = (TorrentManager)Whitebox.getInternalState((Object)cut, TorrentManager.class);
        Assert.assertNotNull((String)"Connector should have been attempted to start.", (Object)Whitebox.getInternalState((Object)torrentManager, (String)"connectorRunnable"));
    }
}

