/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.math.BigInteger;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedInteger;
import org.johnnei.javatorrent.test.TestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BencodedIntegerTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testLong() {
        BencodedInteger integer = new BencodedInteger(35L);
        Assert.assertEquals((String)"asBigInteger returned a different value", (Object)BigInteger.valueOf(35L), (Object)integer.asBigInteger());
        Assert.assertEquals((String)"asLong returned a different value", (long)35L, (long)integer.asLong());
        Assert.assertEquals((String)"Serialized form is incorrect", (Object)"i35e", (Object)integer.serialize());
    }

    @Test
    public void testBigInteger() {
        BencodedInteger integer = new BencodedInteger(BigInteger.valueOf(35L));
        Assert.assertEquals((String)"asBigInteger returned a different value", (Object)BigInteger.valueOf(35L), (Object)integer.asBigInteger());
        Assert.assertEquals((String)"asLong returned a different value", (long)35L, (long)integer.asLong());
        Assert.assertEquals((String)"Serialized form is incorrect", (Object)"i35e", (Object)integer.serialize());
    }

    @Test
    public void testBigIntegerOutOfLongRange() {
        BencodedInteger integer = new BencodedInteger(new BigInteger("12345678987654321012"));
        Assert.assertEquals((String)"asBigInteger returned a different value", (Object)new BigInteger("12345678987654321012"), (Object)integer.asBigInteger());
        Assert.assertEquals((String)"Serialized form is incorrect", (Object)"i12345678987654321012e", (Object)integer.serialize());
    }

    @Test
    public void testBigIntegerNegativeOutOfLongRange() {
        BencodedInteger integer = new BencodedInteger(new BigInteger("-12345678987654321012"));
        Assert.assertEquals((String)"asBigInteger returned a different value", (Object)new BigInteger("-12345678987654321012"), (Object)integer.asBigInteger());
        Assert.assertEquals((String)"Serialized form is incorrect", (Object)"i-12345678987654321012e", (Object)integer.serialize());
    }

    @Test
    public void testBigIntegerNegativeOutOfLongRangeAsLong() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("out of range");
        BencodedInteger integer = new BencodedInteger(new BigInteger("-12345678987654321012"));
        integer.asLong();
    }

    @Test
    public void testBigIntegerOutOfLongRangeAsLong() {
        this.thrown.expect(UnsupportedOperationException.class);
        this.thrown.expectMessage("out of range");
        BencodedInteger integer = new BencodedInteger(new BigInteger("12345678987654321012"));
        integer.asLong();
    }

    @Test
    public void testAsBytes() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedInteger(42L).asBytes();
    }

    @Test
    public void testAsString() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedInteger(42L).asString();
    }

    @Test
    public void testAsList() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedInteger(42L).asList();
    }

    @Test
    public void testAsMap() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedInteger(42L).asMap();
    }

    @Test
    public void testEquality() {
        BencodedInteger base = new BencodedInteger(42L);
        BencodedInteger equal = new BencodedInteger(BigInteger.valueOf(42L));
        BencodedInteger different = new BencodedInteger(7L);
        TestUtils.assertEqualityMethods(base, equal, different);
    }

    @Test
    public void testToString() {
        Assert.assertTrue((String)"Incorrect toString start", (boolean)new BencodedInteger(42L).toString().startsWith("BencodedInteger["));
    }
}

