/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.util.List;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedList;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class BencodedListTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAddAndGet() {
        IBencodedValue valueMockOne = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        IBencodedValue valueMockTwo = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        BencodedList cut = new BencodedList();
        cut.add(valueMockOne);
        Assert.assertEquals((String)"Incorrect amount of items in list", (long)1L, (long)cut.size());
        Assert.assertEquals((String)"Incorrect value got returned", (Object)valueMockOne, (Object)cut.get(0));
        cut.add(valueMockTwo);
        Assert.assertEquals((String)"Incorrect amount of items in list", (long)2L, (long)cut.size());
        Assert.assertEquals((String)"Incorrect value got returned for index 0", (Object)valueMockOne, (Object)cut.get(0));
        Assert.assertEquals((String)"Incorrect value got returned for index 1", (Object)valueMockTwo, (Object)cut.get(1));
    }

    @Test
    public void testSerialize() {
        IBencodedValue valueMockOne = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        IBencodedValue valueMockTwo = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        Mockito.when((Object)valueMockOne.serialize()).thenReturn((Object)"4:spam");
        Mockito.when((Object)valueMockTwo.serialize()).thenReturn((Object)"4:eggs");
        BencodedList cut = new BencodedList();
        cut.add(valueMockOne);
        cut.add(valueMockTwo);
        Assert.assertEquals((String)"Incorrect serialized form", (Object)"l4:spam4:eggse", (Object)cut.serialize());
    }

    @Test
    public void testAsList() {
        IBencodedValue valueMockOne = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        IBencodedValue valueMockTwo = (IBencodedValue)Mockito.mock(IBencodedValue.class);
        Mockito.when((Object)valueMockOne.serialize()).thenReturn((Object)"4:spam");
        Mockito.when((Object)valueMockTwo.serialize()).thenReturn((Object)"4:eggs");
        BencodedList cut = new BencodedList();
        cut.add(valueMockOne);
        cut.add(valueMockTwo);
        List list = cut.asList();
        Assert.assertEquals((String)"Incorrect list copy size", (long)2L, (long)list.size());
        Assert.assertEquals((String)"Incorrect list copy on index 0", (Object)valueMockOne, list.get(0));
        Assert.assertEquals((String)"Incorrect list copy on index 1", (Object)valueMockTwo, list.get(1));
    }

    @Test
    public void testAsBytes() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedList().asBytes();
    }

    @Test
    public void testAsString() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedList().asString();
    }

    @Test
    public void testAsLong() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedList().asLong();
    }

    @Test
    public void testAsMap() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedList().asMap();
    }

    @Test
    public void testAsBigInteger() {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedList().asBigInteger();
    }
}

