/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import org.johnnei.javatorrent.bittorrent.encoding.BencodedString;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BencodedStringTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testAsString() throws Exception {
        BencodedString cut = new BencodedString("Hello World!");
        Assert.assertEquals((String)"asString produced different result.", (Object)"Hello World!", (Object)cut.asString());
    }

    @Test
    public void testAsBytes() throws Exception {
        byte[] input = new byte[]{72, 101, 108, 108, 101, 33};
        BencodedString cut = new BencodedString(input);
        Assert.assertArrayEquals((String)"asBytes produced different result.", (byte[])input, (byte[])cut.asBytes());
    }

    @Test
    public void testAsLong() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedString("").asLong();
    }

    @Test
    public void testAsBigInteger() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedString("").asBigInteger();
    }

    @Test
    public void testAsMap() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedString("").asMap();
    }

    @Test
    public void testAsList() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        new BencodedString("").asList();
    }

    @Test
    public void testSerialize() throws Exception {
        BencodedString cut = new BencodedString("Hello World!");
        Assert.assertEquals((String)"Incorrect serialized form", (Object)"12:Hello World!", (Object)cut.serialize());
    }

    @Test
    public void testSerializeWithNonAsciiCharacters() throws Exception {
        BencodedString cut = new BencodedString("\u03bcTorrent 3.4.7");
        Assert.assertEquals((String)"Incorrect serialized form", (Object)"15:\u03bcTorrent 3.4.7", (Object)cut.serialize());
    }

    @Test
    public void testToString() throws Exception {
        BencodedString cut = new BencodedString("test");
        Assert.assertTrue((String)"Incorrect toString() start", (boolean)cut.toString().startsWith("BencodedString["));
    }
}

