/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.encoding;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.johnnei.javatorrent.bittorrent.encoding.BencodedMap;
import org.johnnei.javatorrent.bittorrent.encoding.Bencoding;
import org.johnnei.javatorrent.bittorrent.encoding.IBencodedValue;
import org.johnnei.javatorrent.network.InStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class BencodingTest {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testDecode() {
        String bencodedInfo = "d4:spaml1:ai2ee4:eggsi12ee";
        String unreadInfo = "i12e";
        Bencoding cut = new Bencoding();
        InStream inStream = new InStream((bencodedInfo + unreadInfo).getBytes(UTF8));
        IBencodedValue value = cut.decode(inStream);
        Map dictionary = value.asMap();
        Assert.assertEquals((String)"Incorrect element count in dictionary", (long)2L, (long)dictionary.size());
        Assert.assertTrue((String)"Dictionary doesn't contain the key 'eggs'", (boolean)dictionary.containsKey("eggs"));
        Assert.assertEquals((String)"Eggs value doesn't match 12", (long)12L, (long)((IBencodedValue)dictionary.get("eggs")).asLong());
        Assert.assertTrue((String)"Dictionary doesn't contain the key 'spam'", (boolean)dictionary.containsKey("spam"));
        List spam = ((IBencodedValue)dictionary.get("spam")).asList();
        Assert.assertEquals((String)"List doesn't contain 2 items", (long)2L, (long)spam.size());
        Assert.assertEquals((String)"List[0] doesn't equal a", (Object)"a", (Object)((IBencodedValue)spam.get(0)).asString());
        Assert.assertEquals((String)"List[1] doesn't equal 2", (long)2L, (long)((IBencodedValue)spam.get(1)).asLong());
        Assert.assertEquals((String)"Incorrect amount of characters read, the 'unreadInfo' should not be consumed.", (long)4L, (long)inStream.available());
    }

    @Test
    public void testNestedDictionary() {
        String bencodedInfo = "d4:spamd4:eggs5:freshee";
        Bencoding cut = new Bencoding();
        InStream inStream = new InStream(bencodedInfo.getBytes(UTF8));
        Map dictionary = cut.decode(inStream).asMap();
        Assert.assertEquals((String)"Incorrect element count in dictionary", (long)1L, (long)dictionary.size());
        Map nestedDictionary = ((IBencodedValue)dictionary.get("spam")).asMap();
        Assert.assertEquals((String)"Incorrect element count in nested-dictionary", (long)1L, (long)nestedDictionary.size());
        Assert.assertEquals((String)"Incorrect string in nested-dictionary", (Object)"fresh", (Object)((IBencodedValue)nestedDictionary.get("eggs")).asString());
        Assert.assertEquals((String)"Incorrect amount of characters read, all should have been read", (long)0L, (long)inStream.available());
    }

    @Test
    public void testNestedDictionaryAndListInList() {
        String bencodedInfo = "ld4:spam4:eggseli42eee";
        Bencoding cut = new Bencoding();
        InStream inStream = new InStream(bencodedInfo.getBytes(UTF8));
        List list = cut.decode(inStream).asList();
        Assert.assertEquals((String)"Incorrect element count in list", (long)2L, (long)list.size());
        Map nestedDictionary = ((IBencodedValue)list.get(0)).asMap();
        Assert.assertEquals((String)"Incorrect element count in nested-dictionary", (long)1L, (long)nestedDictionary.size());
        Assert.assertEquals((String)"Incorrect string in nested-dictionary", (Object)"eggs", (Object)((IBencodedValue)nestedDictionary.get("spam")).asString());
        List nestedList = ((IBencodedValue)list.get(1)).asList();
        Assert.assertEquals((String)"Incorrect nested list element count", (long)1L, (long)nestedList.size());
        Assert.assertEquals((String)"Incorrect integer as second element", (long)42L, (long)((IBencodedValue)nestedList.get(0)).asLong());
        Assert.assertEquals((String)"Incorrect amount of characters read, all should have been read", (long)0L, (long)inStream.available());
    }

    @Test
    public void testDecodeLong() {
        String bencodedInfo = "i231312312312312e";
        Assert.assertEquals((String)"Long didn't get read properly", (long)231312312312312L, (long)new Bencoding().decode(new InStream(bencodedInfo.getBytes(UTF8))).asLong());
    }

    @Test
    public void testDecodeString() {
        String bencodedInfo = "4:spam";
        Assert.assertEquals((String)"Incorrect string", (Object)"spam", (Object)new Bencoding().decode(new InStream(bencodedInfo.getBytes(UTF8))).asString());
    }

    @Test
    public void testDecodeIncompleteString() {
        this.thrown.expect(IllegalArgumentException.class);
        String bencodedInfo = "4:sp";
        new Bencoding().decode(new InStream(bencodedInfo.getBytes(UTF8))).asString();
    }

    @Test
    public void testDecodeStringWithNonAsciiCharacters() {
        String bencodedInfo = "d1:v15:\u03bcTorrent 3.4.72:ypi62954ee";
        Bencoding cut = new Bencoding();
        BencodedMap map = (BencodedMap)cut.decode(new InStream(bencodedInfo.getBytes(UTF8)));
        Assert.assertEquals((String)"Incorrect version string has been read", (Object)"\u03bcTorrent 3.4.7", (Object)((IBencodedValue)map.get("v").get()).asString());
    }
}

