/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import java.time.Duration;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBlock;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MessageBlockTest
extends EasyMockSupport {
    @Test
    public void testStaticMethods() {
        MessageBlock cut = new MessageBlock();
        Assert.assertEquals((String)"Incorrect message ID", (long)7L, (long)cut.getId());
        Assert.assertTrue((String)"Incorrect toString start.", (boolean)cut.toString().startsWith("MessageBlock["));
        cut = new MessageBlock(1, 2, new byte[0]);
        Assert.assertTrue((String)"Incorrect toString start.", (boolean)cut.toString().startsWith("MessageBlock["));
    }

    @Test
    public void testProcessQuickReceive() {
        InStream inStream = new InStream(new byte[]{0, 0, 0, 5, 0, 0, 56, 0, 0}, Duration.ofMillis(200L));
        Peer peerMock = (Peer)this.createMock(Peer.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andStubReturn((Object)torrentMock);
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock);
        torrentMock.onReceivedBlock((AbstractFileSet)EasyMock.eq((Object)fileSetMock), EasyMock.eq((int)5), EasyMock.eq((int)14336), EasyMock.aryEq((byte[])new byte[]{0}));
        peerMock.onReceivedBlock(EasyMock.eq((int)5), EasyMock.eq((int)14336));
        peerMock.addStrike(-1);
        peerMock.setRequestLimit(5);
        this.replayAll();
        MessageBlock cut = new MessageBlock();
        cut.read(inStream);
        cut.process(peerMock);
        this.verifyAll();
    }

    @Test
    public void testProcessInvalidLength() {
        Peer peerMock = (Peer)this.createMock(Peer.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andStubReturn((Object)torrentMock);
        peerMock.onReceivedBlock(EasyMock.eq((int)5), EasyMock.eq((int)14335));
        peerMock.addStrike(1);
        this.replayAll();
        MessageBlock cut = new MessageBlock(5, 14335, new byte[0]);
        cut.process(peerMock);
        this.verifyAll();
    }

    @Test
    public void testReadAndProcess() {
        InStream inStream = new InStream(new byte[]{0, 0, 0, 5, 0, 0, 56, 0, 0});
        Peer peerMock = (Peer)this.createMock(Peer.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andStubReturn((Object)torrentMock);
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock);
        torrentMock.onReceivedBlock((AbstractFileSet)EasyMock.eq((Object)fileSetMock), EasyMock.eq((int)5), EasyMock.eq((int)14336), EasyMock.aryEq((byte[])new byte[]{0}));
        peerMock.onReceivedBlock(EasyMock.eq((int)5), EasyMock.eq((int)14336));
        peerMock.addStrike(-1);
        EasyMock.expect((Object)peerMock.getRequestLimit()).andStubReturn((Object)2);
        peerMock.setRequestLimit(6);
        this.replayAll();
        MessageBlock cut = new MessageBlock();
        cut.read(inStream);
        cut.process(peerMock);
        this.verifyAll();
    }

    @Test
    public void testReadAndProcessHighTrust() {
        InStream inStream = new InStream(new byte[]{0, 0, 0, 5, 0, 0, 56, 0, 0});
        Peer peerMock = (Peer)this.createMock(Peer.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)peerMock.getTorrent()).andStubReturn((Object)torrentMock);
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock);
        torrentMock.onReceivedBlock((AbstractFileSet)EasyMock.eq((Object)fileSetMock), EasyMock.eq((int)5), EasyMock.eq((int)14336), EasyMock.aryEq((byte[])new byte[]{0}));
        peerMock.onReceivedBlock(EasyMock.eq((int)5), EasyMock.eq((int)14336));
        peerMock.addStrike(-1);
        EasyMock.expect((Object)peerMock.getRequestLimit()).andStubReturn((Object)5);
        this.replayAll();
        MessageBlock cut = new MessageBlock();
        cut.read(inStream);
        cut.process(peerMock);
        this.verifyAll();
    }

    @Test
    public void testWrite() {
        MessageBlock cut = new MessageBlock(1, 2, new byte[]{0, 0, 0});
        byte[] expectedOutput = new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0};
        OutStream outStream = new OutStream();
        cut.write(outStream);
        Assert.assertEquals((String)"Incorrect message length", (long)12L, (long)cut.getLength());
        Assert.assertArrayEquals((String)"Incorrect output", (byte[])expectedOutput, (byte[])outStream.toByteArray());
    }
}

