/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageCancel;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MessageCancelTest
extends EasyMockSupport {
    @Test
    public void testWrite() {
        byte[] expectedBytes = new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3};
        OutStream outStream = new OutStream();
        MessageCancel cut = new MessageCancel(1, 2, 3);
        cut.write(outStream);
        Assert.assertEquals((String)"Incorrect message length", (long)(1 + expectedBytes.length), (long)cut.getLength());
        Assert.assertArrayEquals((String)"Incorrect output", (byte[])expectedBytes, (byte[])outStream.toByteArray());
        Assert.assertEquals((String)"Incorrect message ID", (long)8L, (long)cut.getId());
        Assert.assertTrue((String)"Incorrect toString start.", (boolean)cut.toString().startsWith("MessageCancel["));
    }

    @Test
    public void testReadAndProcess() {
        InStream inStream = new InStream(new byte[]{0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3});
        Peer peerMock = (Peer)this.createMock(Peer.class);
        peerMock.cancelBlockRequest(EasyMock.eq((int)1), EasyMock.eq((int)2), EasyMock.eq((int)3), (PeerDirection)EasyMock.eq((Object)PeerDirection.Upload));
        this.replayAll();
        MessageCancel cut = new MessageCancel();
        cut.read(inStream);
        cut.process(peerMock);
        this.verifyAll();
    }
}

