/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.bittorrent.protocol.messages;

import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageHave;
import org.johnnei.javatorrent.network.InStream;
import org.johnnei.javatorrent.network.OutStream;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class MessageHaveTest
extends EasyMockSupport {
    @Test
    public void testWrite() {
        byte[] expectedOutput = new byte[]{0, 0, 0, 18};
        OutStream outStream = new OutStream();
        MessageHave cut = new MessageHave(18);
        cut.write(outStream);
        Assert.assertArrayEquals((String)"Incorrect output", (byte[])expectedOutput, (byte[])outStream.toByteArray());
    }

    @Test
    public void testReadAndProcess() {
        Peer peerMock = (Peer)this.createMock(Peer.class);
        peerMock.setHavingPiece(EasyMock.eq((int)18));
        this.replayAll();
        InStream inStream = new InStream(new byte[]{0, 0, 0, 18});
        MessageHave cut = new MessageHave();
        cut.read(inStream);
        cut.process(peerMock);
        this.verifyAll();
    }

    @Test
    public void testStaticMethods() {
        MessageHave cut = new MessageHave();
        Assert.assertEquals((String)"Incorrect message ID", (long)4L, (long)cut.getId());
        Assert.assertEquals((String)"Incorrect message length", (long)5L, (long)cut.getLength());
        Assert.assertTrue((String)"Incorrect toString start.", (boolean)cut.toString().startsWith("MessageHave["));
    }
}

