/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.disk;

import java.io.File;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.johnnei.javatorrent.disk.DiskJobReadBlock;
import org.johnnei.javatorrent.test.StubEntity;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DiskJobReadBlockTest {
    private final File testFile = new File(DiskJobReadBlockTest.class.getResource("readblock.txt").toURI());
    private CountDownLatch countDownLatch;

    @Before
    public void setUp() {
        this.countDownLatch = new CountDownLatch(1);
    }

    @Test
    public void testReadBlock() throws Exception {
        FileInfo fileInfo = new FileInfo(11560L, 0L, this.testFile, 1);
        AbstractFileSet filesStub = StubEntity.stubAFiles(1, fileInfo, 18);
        Piece piece = new Piece(filesStub, new byte[20], 0, 18, 18);
        DiskJobReadBlock cut = new DiskJobReadBlock(piece, 0, 18, x -> this.countDownLatch.countDown());
        cut.process();
        Assert.assertTrue((String)"Callback method wasn't called", (boolean)this.countDownLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"Incorrect message read", (Object)"Hello world block!", (Object)new String(cut.getBlockData(), Charset.forName("UTF-8")));
        Assert.assertEquals((String)"Incorrect piece", (Object)piece, (Object)cut.getPiece());
        Assert.assertEquals((String)"Incorrect offset", (long)0L, (long)cut.getOffset());
        Assert.assertEquals((String)"Incorrect priority", (long)10L, (long)cut.getPriority());
    }
}

