/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.disk;

import java.io.IOException;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.easymock.IMocksControl;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.internal.disk.IOManager;
import org.junit.Test;

public class IOManagerTest
extends EasyMockSupport {
    @Test
    public void testMethodCallCompletes() {
        IOManager cut = new IOManager();
        cut.run();
    }

    @Test
    public void testOnSucces() throws Exception {
        IOManager cut = new IOManager();
        IDiskJob diskJobMock = (IDiskJob)this.createMock(IDiskJob.class);
        EasyMock.expect((Object)diskJobMock.getPriority()).andStubReturn((Object)5);
        diskJobMock.process();
        this.replayAll();
        cut.addTask(diskJobMock);
        cut.run();
        this.verifyAll();
    }

    @Test
    public void testFailOnFirstProcess() throws Exception {
        IOManager cut = new IOManager();
        IDiskJob diskJobMock = (IDiskJob)this.createMock(IDiskJob.class);
        EasyMock.expect((Object)diskJobMock.getPriority()).andStubReturn((Object)5);
        diskJobMock.process();
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Stubbed IO Exception"));
        diskJobMock.process();
        this.replayAll();
        cut.addTask(diskJobMock);
        cut.run();
        this.verifyAll();
    }

    @Test
    public void testHonorPriority() throws IOException {
        IOManager cut = new IOManager();
        IMocksControl mocksControl = this.createStrictControl();
        IDiskJob diskJobOneMock = (IDiskJob)mocksControl.createMock("JobOne", IDiskJob.class);
        IDiskJob diskJobTwoMock = (IDiskJob)mocksControl.createMock("JobTwo", IDiskJob.class);
        EasyMock.expect((Object)diskJobOneMock.getPriority()).andStubReturn((Object)15);
        EasyMock.expect((Object)diskJobTwoMock.getPriority()).andStubReturn((Object)5);
        diskJobTwoMock.process();
        diskJobOneMock.process();
        diskJobTwoMock.process();
        diskJobOneMock.process();
        this.replayAll();
        cut.addTask(diskJobOneMock);
        cut.addTask(diskJobTwoMock);
        cut.run();
        cut.addTask(diskJobTwoMock);
        cut.addTask(diskJobOneMock);
        cut.run();
        this.verifyAll();
    }
}

