/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.network;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.internal.network.PeerIoRunnable;
import org.johnnei.javatorrent.internal.torrent.TorrentManager;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.johnnei.javatorrent.torrent.peer.PeerDirection;
import org.junit.Before;
import org.junit.Test;

public class PeerIoRunnableTest
extends EasyMockSupport {
    private TorrentManager torrentManager;
    private PeerIoRunnable cut;

    @Before
    public void setUp() {
        this.torrentManager = (TorrentManager)this.createMock(TorrentManager.class);
        this.cut = new PeerIoRunnable(this.torrentManager);
    }

    @Test
    public void testRun() throws Exception {
        Torrent torrent = (Torrent)this.createMock(Torrent.class);
        EasyMock.expect((Object)this.torrentManager.getTorrents()).andReturn(Collections.singletonList(torrent));
        Peer peerOne = (Peer)this.createMock(Peer.class);
        BitTorrentSocket socketOne = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        EasyMock.expect((Object)peerOne.getBitTorrentSocket()).andReturn((Object)socketOne).atLeastOnce();
        EasyMock.expect((Object)socketOne.closed()).andReturn((Object)true);
        Peer peerTwo = (Peer)this.createMock(Peer.class);
        BitTorrentSocket socketTwo = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        EasyMock.expect((Object)peerTwo.getBitTorrentSocket()).andReturn((Object)socketTwo).atLeastOnce();
        EasyMock.expect((Object)socketTwo.closed()).andReturn((Object)false);
        EasyMock.expect((Object)socketTwo.hasOutboundMessages()).andReturn((Object)true);
        socketTwo.sendMessage();
        EasyMock.expect((Object)socketTwo.canReadMessage()).andReturn((Object)false);
        Peer peerThree = (Peer)this.createMock(Peer.class);
        BitTorrentSocket socketThree = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        IMessage messageMock = (IMessage)this.createMock(IMessage.class);
        EasyMock.expect((Object)peerThree.getBitTorrentSocket()).andReturn((Object)socketThree).atLeastOnce();
        EasyMock.expect((Object)socketThree.closed()).andReturn((Object)false);
        EasyMock.expect((Object)socketThree.hasOutboundMessages()).andReturn((Object)false);
        EasyMock.expect((Object)peerThree.getWorkQueueSize((PeerDirection)EasyMock.same((Object)PeerDirection.Upload))).andReturn((Object)1);
        peerThree.queueNextPieceForSending();
        EasyMock.expect((Object)socketThree.canReadMessage()).andReturn((Object)true);
        EasyMock.expect((Object)socketThree.readMessage()).andReturn((Object)messageMock);
        messageMock.process((Peer)EasyMock.same((Object)peerThree));
        Peer peerFour = (Peer)this.createMock(Peer.class);
        BitTorrentSocket socketFour = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        EasyMock.expect((Object)peerFour.getBitTorrentSocket()).andReturn((Object)socketFour).atLeastOnce();
        EasyMock.expect((Object)socketFour.closed()).andReturn((Object)false);
        EasyMock.expect((Object)socketFour.hasOutboundMessages()).andReturn((Object)true);
        socketFour.sendMessage();
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("IOException stub"));
        socketFour.close();
        EasyMock.expect((Object)torrent.getPeers()).andReturn(Arrays.asList(peerOne, peerTwo, peerThree, peerFour));
        this.replayAll();
        this.cut.run();
        this.verifyAll();
    }
}

