/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.async.LoopingRunnable;
import org.johnnei.javatorrent.internal.torrent.TorrentManager;
import org.johnnei.javatorrent.internal.tracker.TrackerManager;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.phases.PhaseRegulator;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.test.TestUtils;
import org.johnnei.javatorrent.torrent.Torrent;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.reflect.Whitebox;

public class TorrentManagerTest
extends EasyMockSupport {
    @Test
    public void testAddRemoveGetTorrent() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IDownloadPhase phaseMock = (IDownloadPhase)this.createMock(IDownloadPhase.class);
        PhaseRegulator regulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledFuture futureMock = (ScheduledFuture)this.createMock(ScheduledFuture.class);
        TrackerManager trackerManager = (TrackerManager)this.createMock(TrackerManager.class);
        EasyMock.expect((Object)torrentClientMock.getExecutorService()).andReturn((Object)executorServiceMock).atLeastOnce();
        EasyMock.expect((Object)torrentClientMock.getPhaseRegulator()).andReturn((Object)regulatorMock).atLeastOnce();
        EasyMock.expect((Object)regulatorMock.createInitialPhase((TorrentClient)EasyMock.same((Object)torrentClientMock), (Torrent)EasyMock.notNull())).andReturn((Object)phaseMock).times(2);
        phaseMock.onPhaseEnter();
        EasyMock.expectLastCall().times(2);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)0L), EasyMock.eq((long)250L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andReturn((Object)futureMock).times(2);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)1L), EasyMock.eq((long)10L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.SECONDS))))).andReturn((Object)futureMock).times(2);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)30L), EasyMock.eq((long)60L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.SECONDS))))).andReturn((Object)futureMock).times(2);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)10L), EasyMock.eq((long)30L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.SECONDS))))).andReturn((Object)futureMock).times(2);
        this.replayAll();
        Torrent torrent = new Torrent.Builder().setName("Test").setHash(DummyEntity.createUniqueTorrentHash(new byte[0][])).setTorrentClient(torrentClientMock).build();
        Torrent torrentTwo = new Torrent.Builder().setName("Test Two").setHash(DummyEntity.createUniqueTorrentHash(new byte[][]{torrent.getHashArray()})).setTorrentClient(torrentClientMock).build();
        TorrentManager cut = new TorrentManager(trackerManager);
        cut.start(torrentClientMock);
        TestUtils.assertNotPresent("Torrent should not have been found yet", cut.getTorrent(torrent.getHashArray()));
        cut.addTorrent(torrent);
        TestUtils.assertPresent("Torrent should have been present", cut.getTorrent(torrent.getHashArray()));
        Assert.assertTrue((String)"Collection should have contained torrent", (boolean)cut.getTorrents().contains(torrent));
        cut.addTorrent(torrentTwo);
        Assert.assertEquals((String)"Torrent should have been equal", (Object)torrent, cut.getTorrent(torrent.getHashArray()).get());
        Assert.assertEquals((String)"Torrent two should have been equal", (Object)torrentTwo, cut.getTorrent(torrentTwo.getHashArray()).get());
        Assert.assertTrue((String)"Collection should have contained torrent", (boolean)cut.getTorrents().contains(torrent));
        Assert.assertTrue((String)"Collection should have contained torrent two", (boolean)cut.getTorrents().contains(torrentTwo));
        cut.removeTorrent(torrentTwo);
        Assert.assertFalse((String)"Collection should not have contained torrent two", (boolean)cut.getTorrents().contains(torrentTwo));
        this.verifyAll();
    }

    @Test
    public void testShutdownTorrent() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        ScheduledExecutorService executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        IDownloadPhase phaseMock = (IDownloadPhase)this.createMock(IDownloadPhase.class);
        PhaseRegulator regulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        ScheduledFuture futureMock = (ScheduledFuture)this.createMock(ScheduledFuture.class);
        TrackerManager trackerManager = (TrackerManager)this.createMock(TrackerManager.class);
        EasyMock.expect((Object)torrentClientMock.getExecutorService()).andReturn((Object)executorServiceMock).atLeastOnce();
        EasyMock.expect((Object)torrentClientMock.getPhaseRegulator()).andReturn((Object)regulatorMock).atLeastOnce();
        EasyMock.expect((Object)regulatorMock.createInitialPhase((TorrentClient)EasyMock.same((Object)torrentClientMock), (Torrent)EasyMock.notNull())).andReturn((Object)phaseMock).times(2);
        phaseMock.onPhaseEnter();
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)futureMock.cancel(EasyMock.eq((boolean)false))).andReturn((Object)true).times(4);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)0L), EasyMock.eq((long)250L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.MILLISECONDS))))).andReturn((Object)futureMock).times(2);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)1L), EasyMock.eq((long)10L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.SECONDS))))).andReturn((Object)futureMock).times(2);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)30L), EasyMock.eq((long)60L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.SECONDS))))).andReturn((Object)futureMock).times(2);
        EasyMock.expect(executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.eq((long)10L), EasyMock.eq((long)30L), (TimeUnit)((Object)EasyMock.eq((Object)((Object)TimeUnit.SECONDS))))).andReturn((Object)futureMock).times(2);
        this.replayAll();
        Torrent torrent = new Torrent.Builder().setName("Test").setHash(DummyEntity.createUniqueTorrentHash(new byte[0][])).setTorrentClient(torrentClientMock).build();
        Torrent torrentTwo = new Torrent.Builder().setName("Test Two").setHash(DummyEntity.createUniqueTorrentHash(new byte[][]{torrent.getHashArray()})).setTorrentClient(torrentClientMock).build();
        TorrentManager cut = new TorrentManager(trackerManager);
        cut.start(torrentClientMock);
        cut.addTorrent(torrent);
        cut.addTorrent(torrentTwo);
        cut.shutdownTorrent(torrentTwo);
        Assert.assertFalse((String)"Collection should not have contained torrent two", (boolean)cut.getTorrents().contains(torrentTwo));
        cut.shutdownTorrent(torrentTwo);
        this.verifyAll();
    }

    @Test
    public void testStartStopWithoutPeerConnector() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        TrackerManager trackerManager = (TrackerManager)this.createMock(TrackerManager.class);
        this.replayAll();
        TorrentManager cut = new TorrentManager(trackerManager);
        cut.start(torrentClientMock);
        LoopingRunnable peerIoRunnable = (LoopingRunnable)Whitebox.getInternalState((Object)cut, (String)"peerIoRunnable");
        Assert.assertNotNull((String)"Peer IO runner should have been started.", (Object)peerIoRunnable);
        cut.stop();
        this.verifyAll();
        Assert.assertFalse((String)"Peer IO runner should have been tasked to stop", (boolean)this.isRunning(peerIoRunnable));
    }

    @Test
    public void testStartStopWithPeerConnector() throws Exception {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        TrackerManager trackerManager = (TrackerManager)this.createMock(TrackerManager.class);
        EasyMock.expect((Object)torrentClientMock.getDownloadPort()).andReturn((Object)DummyEntity.findAvailableTcpPort());
        this.replayAll();
        TorrentManager cut = new TorrentManager(trackerManager);
        cut.start(torrentClientMock);
        cut.enableConnectionAcceptor();
        LoopingRunnable peerIoRunnable = (LoopingRunnable)Whitebox.getInternalState((Object)cut, (String)"peerIoRunnable");
        LoopingRunnable peerConnectorRunnable = (LoopingRunnable)Whitebox.getInternalState((Object)cut, (String)"connectorRunnable");
        Assert.assertNotNull((String)"Peer IO runner should have been started.", (Object)peerIoRunnable);
        Assert.assertNotNull((String)"Peer connector runner should have been started.", (Object)peerConnectorRunnable);
        cut.stop();
        this.verifyAll();
        Assert.assertFalse((String)"Peer IO runner should have been tasked to stop", (boolean)this.isRunning(peerIoRunnable));
        Assert.assertFalse((String)"Peer connector runner should have been tasked to stop", (boolean)this.isRunning(peerConnectorRunnable));
    }

    private boolean isRunning(LoopingRunnable runnable) {
        return (Boolean)Whitebox.getInternalState((Object)runnable, (String)"keepRunning");
    }
}

