/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.internal.torrent.TorrentManager;
import org.johnnei.javatorrent.internal.torrent.TorrentProcessor;
import org.johnnei.javatorrent.internal.tracker.TrackerManager;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.phases.IDownloadPhase;
import org.johnnei.javatorrent.phases.PhaseRegulator;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.choking.IChokingStrategy;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Before;
import org.junit.Test;

public class TorrentProcessorTest
extends EasyMockSupport {
    private TorrentManager managerMock;
    private TorrentClient torrentClient;
    private IDownloadPhase phaseMock;
    private PhaseRegulator phaseRegulatorMock;
    private ScheduledFuture futureMock;
    private ScheduledExecutorService executorServiceMock;

    @Before
    public void setUp() {
        this.managerMock = (TorrentManager)this.createMock(TorrentManager.class);
        this.torrentClient = (TorrentClient)this.createMock(TorrentClient.class);
        this.phaseMock = (IDownloadPhase)this.createMock(IDownloadPhase.class);
        this.phaseMock.onPhaseEnter();
        this.phaseRegulatorMock = (PhaseRegulator)this.createMock(PhaseRegulator.class);
        this.executorServiceMock = (ScheduledExecutorService)this.createMock(ScheduledExecutorService.class);
        this.futureMock = (ScheduledFuture)this.createMock(ScheduledFuture.class);
        EasyMock.expect((Object)this.torrentClient.getPhaseRegulator()).andStubReturn((Object)this.phaseRegulatorMock);
        EasyMock.expect((Object)this.torrentClient.getExecutorService()).andStubReturn((Object)this.executorServiceMock);
        EasyMock.expect((Object)this.phaseRegulatorMock.createInitialPhase((TorrentClient)EasyMock.notNull(), (Torrent)EasyMock.notNull())).andReturn((Object)this.phaseMock);
        EasyMock.expect(this.executorServiceMock.scheduleAtFixedRate((Runnable)EasyMock.notNull(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.notNull()))).andStubReturn((Object)this.futureMock);
    }

    @Test
    public void testUpdateTorrentStateEnd() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        TrackerManager trackerManagerMock = (TrackerManager)this.createMock(TrackerManager.class);
        EasyMock.expect((Object)this.phaseMock.isDone()).andReturn((Object)true);
        this.phaseMock.onPhaseExit();
        EasyMock.expect((Object)this.phaseRegulatorMock.createNextPhase((IDownloadPhase)EasyMock.same((Object)this.phaseMock), (TorrentClient)EasyMock.same((Object)this.torrentClient), (Torrent)EasyMock.same((Object)torrentMock))).andReturn(Optional.empty());
        EasyMock.expect((Object)this.futureMock.cancel(EasyMock.eq((boolean)false))).andReturn((Object)true).times(4);
        this.managerMock.removeTorrent((Torrent)EasyMock.same((Object)torrentMock));
        this.replayAll();
        TorrentProcessor processor = new TorrentProcessor(this.managerMock, trackerManagerMock, this.torrentClient, torrentMock);
        processor.updateTorrentState();
        this.verifyAll();
    }

    @Test
    public void testUpdateTorrentStateChangePhase() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        TrackerManager trackerManagerMock = (TrackerManager)this.createMock(TrackerManager.class);
        IDownloadPhase phaseTwoMock = (IDownloadPhase)this.createMock(IDownloadPhase.class);
        EasyMock.expect((Object)this.phaseMock.isDone()).andReturn((Object)true);
        this.phaseMock.onPhaseExit();
        EasyMock.expect((Object)this.phaseRegulatorMock.createNextPhase((IDownloadPhase)EasyMock.same((Object)this.phaseMock), (TorrentClient)EasyMock.same((Object)this.torrentClient), (Torrent)EasyMock.same((Object)torrentMock))).andReturn(Optional.of(phaseTwoMock));
        phaseTwoMock.onPhaseEnter();
        phaseTwoMock.process();
        this.replayAll();
        TorrentProcessor processor = new TorrentProcessor(this.managerMock, trackerManagerMock, this.torrentClient, torrentMock);
        processor.updateTorrentState();
        this.verifyAll();
    }

    @Test
    public void testUpdateTorrentState() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        TrackerManager trackerManagerMock = (TrackerManager)this.createMock(TrackerManager.class);
        EasyMock.expect((Object)this.phaseMock.isDone()).andReturn((Object)false);
        this.phaseMock.process();
        this.replayAll();
        TorrentProcessor processor = new TorrentProcessor(this.managerMock, trackerManagerMock, this.torrentClient, torrentMock);
        processor.updateTorrentState();
        this.verifyAll();
    }

    @Test
    public void testUpdateChokingStates() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        IChokingStrategy chokingStrategyMock = (IChokingStrategy)this.createMock(IChokingStrategy.class);
        TrackerManager trackerManagerMock = (TrackerManager)this.createMock(TrackerManager.class);
        EasyMock.expect((Object)torrentMock.getPeers()).andReturn(Collections.singletonList(peerMock));
        EasyMock.expect((Object)this.phaseMock.getChokingStrategy()).andReturn((Object)chokingStrategyMock);
        chokingStrategyMock.updateChoking((Peer)EasyMock.same((Object)peerMock));
        this.replayAll();
        TorrentProcessor processor = new TorrentProcessor(this.managerMock, trackerManagerMock, this.torrentClient, torrentMock);
        processor.updateChokingStates();
        this.verifyAll();
    }

    @Test
    public void testRemoveDisconnectedPeers() {
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        TrackerManager trackerManagerMock = (TrackerManager)this.createMock(TrackerManager.class);
        EasyMock.expect((Object)torrentMock.getPeers()).andReturn(Collections.singletonList(peerMock));
        EasyMock.expect((Object)peerMock.getBitTorrentSocket()).andReturn((Object)socketMock);
        EasyMock.expect((Object)socketMock.closed()).andReturn((Object)true);
        torrentMock.removePeer((Peer)EasyMock.same((Object)peerMock));
        this.replayAll();
        TorrentProcessor processor = new TorrentProcessor(this.managerMock, trackerManagerMock, this.torrentClient, torrentMock);
        processor.removeDisconnectedPeers();
        this.verifyAll();
    }
}

