/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.internal.torrent.peer;

import org.johnnei.javatorrent.internal.torrent.peer.Bitfield;
import org.junit.Assert;
import org.junit.Test;

public class BitfieldTest {
    @Test
    public void testHavePiece() {
        Bitfield cut = new Bitfield(1);
        cut.havePiece(9, true);
        Assert.assertEquals((String)"One Piece should have been marked as having", (long)1L, (long)cut.countHavePieces());
        Assert.assertTrue((String)"Piece 9 should have been marked as having", (boolean)cut.hasPiece(9));
        Assert.assertEquals((String)"Byte array should be 2 bytes", (long)2L, (long)cut.getBytes().length);
        cut.havePiece(1, true);
        Assert.assertEquals((String)"Piece should not have been marked as having", (long)2L, (long)cut.countHavePieces());
        Assert.assertTrue((String)"Piece 1 should have been marked as having", (boolean)cut.hasPiece(1));
    }

    @Test
    public void testHavePieceCantExpand() {
        Bitfield cut = new Bitfield(1);
        cut.havePiece(9);
        Assert.assertEquals((String)"Piece should not have been marked as having", (long)0L, (long)cut.countHavePieces());
        Assert.assertFalse((String)"Piece 9 should not have been marked as having", (boolean)cut.hasPiece(9));
        cut.havePiece(1);
        Assert.assertEquals((String)"Piece should not have been marked as having", (long)1L, (long)cut.countHavePieces());
        Assert.assertTrue((String)"Piece 1 should have been marked as having", (boolean)cut.hasPiece(1));
    }

    @Test
    public void testSetSize() {
        Bitfield cut = new Bitfield(1);
        Assert.assertEquals((String)"Size should have been 1 byte", (long)1L, (long)cut.getBytes().length);
        cut.setSize(1);
        Assert.assertEquals((String)"Size should have been 1 byte", (long)1L, (long)cut.getBytes().length);
        cut.setSize(2);
        Assert.assertEquals((String)"Size should have been 1 byte", (long)2L, (long)cut.getBytes().length);
    }
}

