/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.johnnei.javatorrent.network.ConnectionDegradation;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionDegradationTest {
    @Test
    public void testDegradeConnection() {
        ConnectionDegradation cut = new ConnectionDegradation.Builder().registerDefaultConnectionType(SocketTypeOne.class, () -> new SocketTypeOne(), Optional.empty()).registerDefaultConnectionType(SocketTypeOne.class, () -> new SocketTypeOne(), Optional.of(SocketTypeTwo.class)).registerConnectionType(SocketTypeTwo.class, () -> new SocketTypeTwo(), Optional.empty()).build();
        ISocket preferredSocket = cut.createPreferredSocket();
        Assert.assertTrue((String)"Incorrect preferred socket", (boolean)(preferredSocket instanceof SocketTypeOne));
        Optional fallbackSocket = cut.degradeSocket(preferredSocket);
        Assert.assertTrue((String)"Fallback socket should be present", (boolean)fallbackSocket.isPresent());
        Assert.assertTrue((String)"Incorrect fallback socket", (boolean)(fallbackSocket.get() instanceof SocketTypeTwo));
        fallbackSocket = cut.degradeSocket((ISocket)fallbackSocket.get());
        Assert.assertFalse((String)"Second fallback socket shouldn't have been there", (boolean)fallbackSocket.isPresent());
        Assert.assertTrue((String)"Incorrect toString start", (boolean)cut.toString().startsWith("ConnectionDegradation["));
    }

    @Test(expected=IllegalStateException.class)
    public void testBadConfiguration() {
        new ConnectionDegradation.Builder().registerDefaultConnectionType(SocketTypeOne.class, () -> new SocketTypeOne(), Optional.of(SocketTypeTwo.class)).registerConnectionType(SocketTypeTwo.class, () -> new SocketTypeTwo(), Optional.of(SocketTypeThree.class)).build();
    }

    private static class ASocketType
    implements ISocket {
        private ASocketType() {
        }

        public void connect(InetSocketAddress endpoint) throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public void close() throws IOException {
        }

        public boolean isClosed() {
            return false;
        }

        public boolean isInputShutdown() {
            return false;
        }

        public boolean isOutputShutdown() {
            return false;
        }

        public void flush() throws IOException {
        }
    }

    private static class SocketTypeThree
    extends ASocketType {
        private SocketTypeThree() {
        }
    }

    private static class SocketTypeTwo
    extends ASocketType {
        private SocketTypeTwo() {
        }
    }

    private static class SocketTypeOne
    extends ASocketType {
        private SocketTypeOne() {
        }
    }
}

