/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.IOException;
import java.time.Duration;
import org.johnnei.javatorrent.internal.utils.CheckedRunnable;
import org.johnnei.javatorrent.internal.utils.CheckedSupplier;
import org.johnnei.javatorrent.network.InStream;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.powermock.reflect.Whitebox;

public class InStreamTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testRead() {
        InStream inStream = new InStream(new byte[]{1, 23, 1, 35, 1, 35, 69, 103, 1, 35, 69, 103, -119, -85, -51, -17, -1, -1, -1, 1, 2, 3, 4, 1, 2, 1, 2, 3, 4, 0, 74, 104, 101, 108, 108, 111, 32, 119, 111, 114, 108, 100});
        byte[] bufferReadFully = new byte[4];
        byte[] bufferReadFullyOffset = new byte[]{1, 2, 3, 4};
        byte[] expectedBytesReadFully = new byte[]{1, 2, 3, 4};
        byte[] expectedBytesReadFullyOffset = new byte[]{1, 1, 2, 4};
        byte[] expectedBytesReadFullyInt = new byte[]{1, 2, 3, 4};
        Assert.assertTrue((String)"Available bytes is <= 0", (inStream.available() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"readBoolean returned wrong value", (boolean)inStream.readBoolean());
        Assert.assertEquals((String)"readByte returned wrong value", (long)23L, (long)inStream.readByte());
        Assert.assertEquals((String)"readShort returned wrong value", (long)291L, (long)inStream.readShort());
        Assert.assertEquals((String)"readInt returned wrong value", (long)19088743L, (long)inStream.readInt());
        Assert.assertEquals((String)"readLong returned wrong value", (long)81985529216486895L, (long)inStream.readLong());
        Assert.assertEquals((String)"readUnsignedByte returned wrong value", (long)255L, (long)inStream.readUnsignedByte());
        Assert.assertEquals((String)"readUnsignedShort returned wrong value", (long)65535L, (long)inStream.readUnsignedShort());
        inStream.readFully(bufferReadFully);
        inStream.readFully(bufferReadFullyOffset, 1, 2);
        Assert.assertArrayEquals((String)"readFully(byte[]) returned wrong value", (byte[])expectedBytesReadFully, (byte[])bufferReadFully);
        Assert.assertArrayEquals((String)"readFully(byte[], int, int) returned wrong value", (byte[])expectedBytesReadFullyOffset, (byte[])bufferReadFullyOffset);
        Assert.assertArrayEquals((String)"readFully(int) returned wrong value", (byte[])expectedBytesReadFullyInt, (byte[])inStream.readFully(4));
        Assert.assertEquals((String)"readChar returned wrong value", (long)74L, (long)inStream.readChar());
        Assert.assertEquals((String)"readString returned wrong value", (Object)"hello world", (Object)inStream.readString(11));
        Assert.assertEquals((String)"All data should have been read", (long)0L, (long)inStream.available());
    }

    @Test
    public void testSkipBytes() {
        InStream inStream = new InStream(new byte[]{0, 0, 0});
        Assert.assertEquals((String)"Incorrect starting size", (long)3L, (long)inStream.available());
        inStream.skipBytes(2);
        Assert.assertEquals((String)"Incorrect ending size", (long)1L, (long)inStream.available());
    }

    @Test
    public void testMoveBack() {
        InStream inStream = new InStream(new byte[]{1, 2});
        Assert.assertEquals((String)"Incorrect starting size", (long)2L, (long)inStream.available());
        Assert.assertEquals((String)"Incorrect byte value", (long)1L, (long)inStream.readByte());
        Assert.assertEquals((String)"Incorrect available, should have read only 1 byte at this point.", (long)1L, (long)inStream.available());
        inStream.moveBack(1);
        Assert.assertEquals((String)"Incorrect available, should have moved back to beginning of stream", (long)2L, (long)inStream.available());
        Assert.assertEquals((String)"Incorrect byte value", (long)1L, (long)inStream.readByte());
        Assert.assertEquals((String)"Incorrect byte value", (long)2L, (long)inStream.readByte());
    }

    @Test
    public void testMark() {
        InStream inStream = new InStream(new byte[]{0, 0, 0, 0});
        inStream.mark();
        inStream.readShort();
        Assert.assertEquals((String)"Incorrect available value after reading short with mark", (long)2L, (long)inStream.available());
        inStream.resetToMark();
        Assert.assertEquals((String)"Incorrect available value after returning to mark", (long)4L, (long)inStream.available());
    }

    @Test
    public void testDuration() {
        InStream inStream = new InStream(new byte[0], Duration.ZERO);
        Assert.assertEquals((String)"Incorrect duration", (Object)Duration.ZERO, inStream.getReadDuration().get());
        inStream = new InStream(new byte[]{0, 0}, 1, 1);
        Assert.assertFalse((String)"Incorrect duration", (boolean)inStream.getReadDuration().isPresent());
    }

    @Test
    public void testExceptionDoUncheckedSupplier() throws Exception {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("IO Exception on in-memory byte array");
        CheckedSupplier runnable = () -> {
            throw new IOException("Test exception path");
        };
        InStream cut = new InStream(new byte[0]);
        Whitebox.invokeMethod((Object)cut, (String)"doUnchecked", (Object[])new Object[]{runnable});
    }

    @Test
    public void testExceptionDoUncheckedRunnable() throws Exception {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("IO Exception on in-memory byte array");
        CheckedRunnable runnable = () -> {
            throw new IOException("Test exception path");
        };
        InStream cut = new InStream(new byte[0]);
        Whitebox.invokeMethod((Object)cut, (String)"doUnchecked", (Object[])new Object[]{runnable});
    }
}

