/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.IOException;
import org.johnnei.javatorrent.internal.utils.CheckedRunnable;
import org.johnnei.javatorrent.network.OutStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.powermock.reflect.Whitebox;

public class OutStreamTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private OutStream cut;

    @Before
    public void setUp() {
        this.cut = new OutStream();
    }

    @Test
    public void testWriteByteArray() throws Exception {
        byte[] expectedOutput = new byte[]{1, 2, 3, 4};
        this.cut.write(expectedOutput);
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)4L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testWriteByteArrayOffset() throws Exception {
        byte[] expectedOutput = new byte[]{2, 3};
        byte[] input = new byte[]{1, 2, 3, 4};
        this.cut.write(input, 1, 2);
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)2L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testWriteBoolean() throws Exception {
        byte[] expectedOutput = new byte[]{0, 1};
        this.cut.writeBoolean(false);
        this.cut.writeBoolean(true);
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)2L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testWriteByte() throws Exception {
        byte[] expectedOutput = new byte[]{45};
        this.cut.writeByte(45);
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)1L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testWriteInt() throws Exception {
        byte[] expectedOutput = new byte[]{95, -62, 47, -9};
        this.cut.writeInt(1606561783);
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)4L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testWriteLong() throws Exception {
        byte[] expectedOutput = new byte[]{44, -105, 78, -36, 91, -20, 118, 88};
        this.cut.writeLong(3213123567494133336L);
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)8L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testWriteShort() throws Exception {
        byte[] expectedOutput = new byte[]{125, -112};
        this.cut.writeShort(32144);
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)2L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testWriteString() throws Exception {
        byte[] expectedOutput = new byte[]{66, 105, 116, 84, 111, 114, 114, 101, 110, 116, 32, 112, 114, 111, 116, 111, 99, 111, 108};
        this.cut.writeString("BitTorrent protocol");
        Assert.assertEquals((String)"Incorrect amount of bytes written", (long)19L, (long)this.cut.size());
        Assert.assertArrayEquals((String)"Incorrect written bytes", (byte[])expectedOutput, (byte[])this.cut.toByteArray());
    }

    @Test
    public void testExceptionWriteUnchecked() throws Exception {
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("IO Exception on in-memory byte array");
        CheckedRunnable runnable = () -> {
            throw new IOException("Test exception path");
        };
        OutStream cut = new OutStream();
        Whitebox.invokeMethod((Object)cut, (String)"writeUnchecked", (Object[])new Object[]{runnable});
    }
}

