/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Optional;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.protocol.BitTorrentHandshake;
import org.johnnei.javatorrent.bittorrent.protocol.MessageFactory;
import org.johnnei.javatorrent.internal.network.socket.ISocket;
import org.johnnei.javatorrent.internal.network.socket.TcpSocket;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.network.TcpPeerConnectionAcceptor;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TcpPeerConnectionAcceptorTest
extends EasyMockSupport {
    private TorrentClient torrentClientMock;
    private BitTorrentSocket bitTorrentSocketMock;
    private ServerSocket serverSocketMock;
    private Peer peerMock;
    private TcpPeerConnectionAcceptor cut;

    @Before
    public void setUp() {
        this.torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
    }

    private void setUpStubbedCreateSocket() throws IOException {
        this.bitTorrentSocketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        this.serverSocketMock = (ServerSocket)this.createMock(ServerSocket.class);
        this.peerMock = (Peer)this.createMock(Peer.class);
        this.cut = new PartialStubbedTcpPeerAcceptor();
    }

    @Test
    public void testAcceptPeer() throws Exception {
        this.setUpStubbedCreateSocket();
        Socket socketMock = (Socket)this.createMock(Socket.class);
        BitTorrentHandshake handshake = new BitTorrentHandshake(DummyEntity.createRandomBytes(20), DummyEntity.createRandomBytes(8), DummyEntity.createPeerId());
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        byte[] extensionBytes = DummyEntity.createRandomBytes(8);
        byte[] peerId = DummyEntity.createPeerId();
        EasyMock.expect((Object)this.serverSocketMock.accept()).andReturn((Object)socketMock);
        EasyMock.expect((Object)this.bitTorrentSocketMock.readHandshake()).andReturn((Object)handshake);
        EasyMock.expect((Object)this.torrentClientMock.getTorrentByHash(EasyMock.aryEq((byte[])handshake.getTorrentHash()))).andReturn(Optional.of(torrentMock));
        EasyMock.expect((Object)this.torrentClientMock.getExtensionBytes()).andReturn((Object)extensionBytes);
        EasyMock.expect((Object)this.torrentClientMock.getPeerId()).andReturn((Object)peerId);
        EasyMock.expect((Object)torrentMock.getHashArray()).andReturn((Object)handshake.getTorrentHash());
        this.bitTorrentSocketMock.sendHandshake(EasyMock.aryEq((byte[])extensionBytes), EasyMock.aryEq((byte[])peerId), EasyMock.aryEq((byte[])handshake.getTorrentHash()));
        torrentMock.addPeer((Peer)EasyMock.same((Object)this.peerMock));
        this.replayAll();
        this.cut.run();
        this.verifyAll();
    }

    @Test
    public void testDenyPeer() throws Exception {
        this.setUpStubbedCreateSocket();
        Socket socketMock = (Socket)this.createMock(Socket.class);
        BitTorrentHandshake handshake = new BitTorrentHandshake(DummyEntity.createRandomBytes(20), DummyEntity.createRandomBytes(8), DummyEntity.createPeerId());
        EasyMock.expect((Object)this.serverSocketMock.accept()).andReturn((Object)socketMock);
        EasyMock.expect((Object)this.bitTorrentSocketMock.readHandshake()).andReturn((Object)handshake);
        EasyMock.expect((Object)this.torrentClientMock.getTorrentByHash(EasyMock.aryEq((byte[])handshake.getTorrentHash()))).andReturn(Optional.empty());
        this.bitTorrentSocketMock.close();
        this.replayAll();
        this.cut.run();
        this.verifyAll();
    }

    @Test
    public void testOnExceptionAccept() throws Exception {
        this.setUpStubbedCreateSocket();
        EasyMock.expect((Object)this.serverSocketMock.accept()).andThrow((Throwable)new IOException("Test Exception case"));
        this.replayAll();
        this.cut.run();
        this.verifyAll();
    }

    @Test
    public void testOnExceptionReadHandshake() throws Exception {
        this.setUpStubbedCreateSocket();
        Socket socketMock = (Socket)this.createMock(Socket.class);
        EasyMock.expect((Object)this.serverSocketMock.accept()).andReturn((Object)socketMock);
        EasyMock.expect((Object)this.bitTorrentSocketMock.readHandshake()).andThrow((Throwable)new IOException("Test Exception case"));
        socketMock.close();
        this.replayAll();
        this.cut.run();
        this.verifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateCalls() throws Exception {
        MessageFactory messageFactoryMock = (MessageFactory)this.createMock(MessageFactory.class);
        this.torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        TcpSocket socketMock = (TcpSocket)this.createMock(TcpSocket.class);
        BitTorrentSocket bitTorrentSocketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Torrent torrent = DummyEntity.createUniqueTorrent(new Torrent[0]);
        int port = DummyEntity.findAvailableTcpPort();
        EasyMock.expect((Object)this.torrentClientMock.getDownloadPort()).andReturn((Object)port);
        EasyMock.expect((Object)this.torrentClientMock.getMessageFactory()).andReturn((Object)messageFactoryMock);
        EasyMock.expect((Object)socketMock.getInputStream()).andReturn((Object)new ByteArrayInputStream(new byte[0]));
        EasyMock.expect((Object)socketMock.getOutputStream()).andReturn((Object)new ByteArrayOutputStream());
        this.replayAll();
        try {
            this.cut = new TcpPeerConnectionAcceptor(this.torrentClientMock);
            Assert.assertNotNull((String)"Didn't create a socket", (Object)this.cut.createSocket((ISocket)socketMock));
            this.cut.createPeer(bitTorrentSocketMock, torrent, DummyEntity.createRandomBytes(8), DummyEntity.createPeerId());
        }
        finally {
            this.verifyAll();
        }
    }

    private class PartialStubbedTcpPeerAcceptor
    extends TcpPeerConnectionAcceptor {
        public PartialStubbedTcpPeerAcceptor() throws IOException {
            super(TcpPeerConnectionAcceptorTest.this.torrentClientMock);
        }

        ServerSocket createServerSocket() {
            return TcpPeerConnectionAcceptorTest.this.serverSocketMock;
        }

        BitTorrentSocket createSocket(ISocket socket) throws IOException {
            Assert.assertNotNull((Object)socket);
            return TcpPeerConnectionAcceptorTest.this.bitTorrentSocketMock;
        }

        Peer createPeer(BitTorrentSocket socket, Torrent torrent, byte[] extensionBytes, byte[] peerId) {
            Assert.assertEquals((String)"Incorrect socket", (Object)TcpPeerConnectionAcceptorTest.this.bitTorrentSocketMock, (Object)socket);
            Assert.assertNotNull((String)"Creating peer with null torrent", (Object)torrent);
            Assert.assertNotNull((String)"Creating peer with null extension bytes", (Object)extensionBytes);
            Assert.assertNotNull((String)"Creating peer with null id bytes", (Object)peerId);
            return TcpPeerConnectionAcceptorTest.this.peerMock;
        }
    }
}

