/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.phases;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageRequest;
import org.johnnei.javatorrent.bittorrent.tracker.ITracker;
import org.johnnei.javatorrent.bittorrent.tracker.TorrentInfo;
import org.johnnei.javatorrent.bittorrent.tracker.TrackerEvent;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.phases.PhaseData;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.test.StubEntity;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.algos.pieceselector.FullPieceSelect;
import org.johnnei.javatorrent.torrent.algos.pieceselector.IPieceSelector;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.reflect.Whitebox;

@RunWith(value=EasyMockRunner.class)
public class PhaseDataTest
extends EasyMockSupport {
    @Test
    public void testGetRelevantPeers() {
        TorrentClient torrentClientMock = StubEntity.stubTorrentClient(this);
        Peer peerOne = (Peer)this.createMock(Peer.class);
        Peer peerTwo = (Peer)this.createMock(Peer.class);
        Peer peerThree = (Peer)this.createMock(Peer.class);
        Peer peerFour = (Peer)this.createMock(Peer.class);
        Peer peerFive = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerOne.hasPiece(EasyMock.anyInt())).andReturn((Object)false).atLeastOnce();
        EasyMock.expect((Object)peerTwo.hasPiece(EasyMock.anyInt())).andReturn((Object)true).atLeastOnce();
        EasyMock.expect((Object)peerThree.hasPiece(EasyMock.anyInt())).andReturn((Object)true).atLeastOnce();
        EasyMock.expect((Object)peerFour.hasPiece(EasyMock.anyInt())).andReturn((Object)false).atLeastOnce();
        EasyMock.expect((Object)peerFive.hasPiece(EasyMock.anyInt())).andReturn((Object)true).atLeastOnce();
        this.replayAll();
        Torrent torrent = DummyEntity.createUniqueTorrent(new Torrent[0]);
        torrent.setFileSet(StubEntity.stubAFiles(5));
        List<Peer> peerList = Arrays.asList(peerOne, peerTwo, peerThree, peerFour, peerFive);
        PhaseData cut = new PhaseData(torrentClientMock, torrent);
        Collection relevantPeers = cut.getRelevantPeers(peerList);
        Assert.assertEquals((String)"Incorrect amount of peers", (long)3L, (long)relevantPeers.size());
        Assert.assertTrue((String)"Relevant peer is missing", (boolean)relevantPeers.contains(peerTwo));
        Assert.assertTrue((String)"Relevant peer is missing", (boolean)relevantPeers.contains(peerThree));
        Assert.assertTrue((String)"Relevant peer is missing", (boolean)relevantPeers.contains(peerFive));
        this.verifyAll();
    }

    private ITracker createTrackerExpectingSetCompleted(Torrent torrent) {
        ITracker trackerMock = (ITracker)this.createMock(ITracker.class);
        TorrentInfo torrentInfoMock = (TorrentInfo)this.createMock(TorrentInfo.class);
        EasyMock.expect((Object)trackerMock.getInfo((Torrent)EasyMock.same((Object)torrent))).andReturn(Optional.of(torrentInfoMock));
        torrentInfoMock.setEvent((TrackerEvent)EasyMock.eq((Object)TrackerEvent.EVENT_COMPLETED));
        return trackerMock;
    }

    @Test
    public void testOnPhaseExit() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        ITracker trackerOne = this.createTrackerExpectingSetCompleted(torrentMock);
        ITracker trackerTwo = this.createTrackerExpectingSetCompleted(torrentMock);
        EasyMock.expect((Object)torrentClientMock.getTrackersFor((Torrent)EasyMock.same((Object)torrentMock))).andReturn(Arrays.asList(trackerOne, trackerTwo));
        this.replayAll();
        PhaseData cut = new PhaseData(torrentClientMock, torrentMock);
        cut.onPhaseExit();
        this.verifyAll();
    }

    @Test
    public void testOnPhaseEnter() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        torrentMock.checkProgress();
        torrentMock.setPieceSelector((IPieceSelector)EasyMock.isA(FullPieceSelect.class));
        this.replayAll();
        PhaseData cut = new PhaseData(torrentClientMock, torrentMock);
        cut.onPhaseEnter();
        this.verifyAll();
    }

    @Test
    public void testIsDone() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock);
        EasyMock.expect((Object)fileSetMock.isDone()).andReturn((Object)true);
        this.replayAll();
        PhaseData cut = new PhaseData(torrentClientMock, torrentMock);
        boolean result = cut.isDone();
        this.verifyAll();
        Assert.assertTrue((String)"File set should have returned done, so the phase should have been done", (boolean)result);
    }

    @Test
    public void testProcessTestConcurrentBlockGiveaway() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        IPieceSelector pieceSelectorMock = (IPieceSelector)this.createMock(IPieceSelector.class);
        BitTorrentSocket bitTorrentSocketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        EasyMock.expect((Object)pieceMock.hasBlockWithStatus((BlockStatus)EasyMock.eq((Object)BlockStatus.Needed))).andReturn((Object)true);
        EasyMock.expect((Object)pieceMock.getRequestBlock()).andReturn(Optional.empty());
        EasyMock.expect((Object)pieceMock.getIndex()).andReturn((Object)0).atLeastOnce();
        Peer peer = DummyEntity.createPeer(bitTorrentSocketMock);
        peer.setRequestLimit(1);
        peer.setHavingPiece(0);
        EasyMock.expect((Object)torrentMock.getPeers()).andReturn(Collections.singletonList(peer));
        EasyMock.expect((Object)torrentMock.getPieceSelector()).andReturn((Object)pieceSelectorMock);
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock);
        EasyMock.expect((Object)pieceSelectorMock.getPieceForPeer((Peer)EasyMock.same((Object)peer))).andReturn(Optional.of(pieceMock));
        EasyMock.expect((Object)fileSetMock.getNeededPieces()).andReturn(Collections.singletonList(pieceMock).stream());
        this.replayAll();
        PhaseData cut = new PhaseData(torrentClientMock, torrentMock);
        cut.process();
        this.verifyAll();
    }

    @Test
    public void testProcessHitRequestLimit() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        IPieceSelector pieceSelectorMock = (IPieceSelector)this.createMock(IPieceSelector.class);
        BitTorrentSocket bitTorrentSocketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece piece = new Piece(null, null, 0, 8, 4);
        Peer peer = DummyEntity.createPeer(bitTorrentSocketMock);
        peer.setRequestLimit(1);
        peer.setHavingPiece(0);
        EasyMock.expect((Object)torrentMock.getPeers()).andReturn(Collections.singletonList(peer));
        EasyMock.expect((Object)torrentMock.getPieceSelector()).andReturn((Object)pieceSelectorMock);
        EasyMock.expect((Object)pieceSelectorMock.getPieceForPeer((Peer)EasyMock.same((Object)peer))).andReturn(Optional.of(piece));
        bitTorrentSocketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)4).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getNeededPieces()).andReturn(Collections.singletonList(piece).stream());
        this.replayAll();
        Whitebox.setInternalState((Object)peer, Torrent.class, (Object)torrentMock);
        PhaseData cut = new PhaseData(torrentClientMock, torrentMock);
        cut.process();
        this.verifyAll();
    }

    @Test
    public void testProcess() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        IPieceSelector pieceSelectorMock = (IPieceSelector)this.createMock(IPieceSelector.class);
        BitTorrentSocket bitTorrentSocketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece piece = new Piece(null, null, 0, 8, 4);
        Peer peer = DummyEntity.createPeer(bitTorrentSocketMock);
        peer.setRequestLimit(2);
        peer.setHavingPiece(0);
        EasyMock.expect((Object)torrentMock.getPeers()).andReturn(Collections.singletonList(peer));
        EasyMock.expect((Object)torrentMock.getPieceSelector()).andReturn((Object)pieceSelectorMock);
        EasyMock.expect((Object)pieceSelectorMock.getPieceForPeer((Peer)EasyMock.same((Object)peer))).andReturn(Optional.of(piece));
        bitTorrentSocketMock.enqueueMessage((IMessage)EasyMock.isA(MessageRequest.class));
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)4).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getNeededPieces()).andReturn(Collections.singletonList(piece).stream());
        this.replayAll();
        Whitebox.setInternalState((Object)peer, Torrent.class, (Object)torrentMock);
        PhaseData cut = new PhaseData(torrentClientMock, torrentMock);
        cut.process();
        this.verifyAll();
    }

    @Test
    public void testProcessNoPieceReturned() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Torrent torrentMock = (Torrent)this.createMock(Torrent.class);
        IPieceSelector pieceSelectorMock = (IPieceSelector)this.createMock(IPieceSelector.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        Piece piece = new Piece(null, null, 0, 8, 4);
        EasyMock.expect((Object)torrentMock.getPeers()).andReturn(Collections.singletonList(peerMock));
        EasyMock.expect((Object)torrentMock.getPieceSelector()).andReturn((Object)pieceSelectorMock);
        EasyMock.expect((Object)pieceSelectorMock.getPieceForPeer((Peer)EasyMock.same((Object)peerMock))).andReturn(Optional.empty());
        EasyMock.expect((Object)torrentMock.getFileSet()).andReturn((Object)fileSetMock);
        EasyMock.expect((Object)peerMock.hasPiece(EasyMock.eq((int)0))).andReturn((Object)true);
        EasyMock.expect((Object)fileSetMock.getNeededPieces()).andReturn(Collections.singletonList(piece).stream());
        this.replayAll();
        PhaseData cut = new PhaseData(torrentClientMock, torrentMock);
        cut.process();
        this.verifyAll();
    }
}

