/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.phases;

import java.util.Arrays;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.phases.PhaseSeed;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PhaseSeedTest {
    private TorrentClient torrentClientMock = (TorrentClient)Mockito.mock(TorrentClient.class);
    private Torrent torrentMock = (Torrent)Mockito.mock(Torrent.class);
    private PhaseSeed cut;

    @Before
    public void setUp() {
        this.cut = new PhaseSeed(this.torrentClientMock, this.torrentMock);
    }

    @Test
    public void testProcess() throws Exception {
        Peer peerMockOne = (Peer)Mockito.mock(Peer.class);
        Peer peerMockTwo = (Peer)Mockito.mock(Peer.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)Mockito.mock(AbstractFileSet.class);
        BitTorrentSocket socketMock = (BitTorrentSocket)Mockito.mock(BitTorrentSocket.class);
        Mockito.when((Object)this.torrentMock.getPeers()).thenReturn(Arrays.asList(peerMockOne, peerMockTwo));
        Mockito.when((Object)this.torrentMock.getFileSet()).thenReturn((Object)fileSetMock);
        Mockito.when((Object)fileSetMock.getPieceCount()).thenReturn((Object)2);
        Mockito.when((Object)peerMockOne.countHavePieces()).thenReturn((Object)1);
        Mockito.when((Object)peerMockTwo.countHavePieces()).thenReturn((Object)2);
        Mockito.when((Object)peerMockTwo.getBitTorrentSocket()).thenReturn((Object)socketMock);
        this.cut.process();
        ((BitTorrentSocket)Mockito.verify((Object)socketMock)).close();
    }

    @Test
    public void testIsDone() {
        Assert.assertFalse((String)"This phase will never end", (boolean)this.cut.isDone());
    }

    @Test
    public void testOnPhaseEnter() {
        this.cut.onPhaseEnter();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.torrentClientMock, this.torrentMock});
    }

    @Test
    public void testOnPhaseExit() {
        this.cut.onPhaseExit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.torrentClientMock, this.torrentMock});
    }

    @Test
    public void testGetChokingStrategy() {
        Assert.assertNotNull((String)"This method may never return null, even though won't care about what kind of strategy it returns.", (Object)this.cut.getChokingStrategy());
    }
}

