/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.test;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Supplier;
import org.easymock.EasyMock;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.peer.Peer;

public class DummyEntity {
    public static byte[] createRandomBytes(int amount) {
        Random random = new Random();
        byte[] bytes = new byte[amount];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(random.nextInt() & 0xFF);
        }
        return bytes;
    }

    public static byte[] createUniqueTorrentHash(byte[] ... hashes) {
        return DummyEntity.createUniqueArray(() -> DummyEntity.createRandomBytes(20), hashes);
    }

    public static byte[] createUniquePeerId(byte[] ... peerIds) {
        return DummyEntity.createUniqueArray(DummyEntity::createPeerId, peerIds);
    }

    private static byte[] createUniqueArray(Supplier<byte[]> supplier, byte[] ... hashes) {
        byte[] newHash;
        boolean passed;
        block0: do {
            passed = true;
            newHash = supplier.get();
            for (byte[] hash : hashes) {
                if (!Arrays.equals(newHash, hash)) continue;
                passed = false;
                continue block0;
            }
        } while (!passed);
        return newHash;
    }

    public static Peer createPeer() {
        BitTorrentSocket socketMock = (BitTorrentSocket)EasyMock.createMock(BitTorrentSocket.class);
        EasyMock.replay((Object[])new Object[]{socketMock});
        return DummyEntity.createPeer(socketMock);
    }

    public static Peer createPeer(BitTorrentSocket socket) {
        return DummyEntity.createPeer(socket, DummyEntity.createUniqueTorrent(new Torrent[0]));
    }

    public static Peer createPeer(BitTorrentSocket socket, Torrent torrent) {
        return new Peer.Builder().setSocket(socket).setTorrent(torrent).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(DummyEntity.createPeerId()).build();
    }

    public static Torrent createUniqueTorrent(Torrent ... torrents) {
        byte[][] hashes = new byte[torrents.length][];
        for (int i = 0; i < torrents.length; ++i) {
            hashes[i] = torrents[i].getHashArray();
        }
        byte[] hash = DummyEntity.createUniqueTorrentHash(hashes);
        return new Torrent.Builder().setHash(hash).setName("Dummy Torrent").build();
    }

    public static Torrent createUniqueTorrent(TorrentClient torrentClient, Torrent ... torrents) {
        byte[][] hashes = new byte[torrents.length][];
        for (int i = 0; i < torrents.length; ++i) {
            hashes[i] = torrents[i].getHashArray();
        }
        byte[] hash = DummyEntity.createUniqueTorrentHash(hashes);
        return new Torrent.Builder().setHash(hash).setTorrentClient(torrentClient).setName("Dummy Torrent").build();
    }

    public static byte[] createPeerId() {
        Random random = new Random();
        byte[] peerId = new byte[20];
        peerId[0] = 45;
        peerId[1] = 74;
        peerId[2] = 84;
        peerId[3] = 48;
        peerId[4] = 48;
        peerId[5] = 49;
        peerId[6] = 49;
        peerId[7] = 45;
        for (int i = 8; i < peerId.length; ++i) {
            peerId[i] = (byte)(random.nextInt() & 0xFF);
        }
        return peerId;
    }

    public static int findAvailableTcpPort() throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static int findAvailableUdpPort() {
        int port = 27960;
        DatagramSocket socket = null;
        while (port <= 65535) {
            try {
                socket = new DatagramSocket(port);
                int n = port;
                return n;
            }
            catch (Exception e) {
                ++port;
            }
            finally {
                if (socket == null) continue;
                socket.close();
            }
        }
        throw new IllegalStateException("All ports from 27960 and up are in use.");
    }
}

