/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.johnnei.javatorrent.torrent.FileInfo;
import org.johnnei.javatorrent.torrent.TorrentFileSet;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.utils.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.powermock.reflect.Whitebox;

public class TorrentFileSetTest {
    private static final String SINGLE_FILE_TORRENT = "gimp-2.8.16-setup-1.exe.torrent";
    private static final String MULTI_FILE_TORRENT = "my.sql.apache.2.2.php.notepad.torrent";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    private TorrentFileSet getMultiFileTorrent() throws Exception {
        File file = new File(TorrentFileSetTest.class.getResource(MULTI_FILE_TORRENT).toURI());
        return new TorrentFileSet(file, this.temporaryFolder.newFolder());
    }

    private TorrentFileSet getSingleFileTorrent() throws Exception {
        File file = new File(TorrentFileSetTest.class.getResource(SINGLE_FILE_TORRENT).toURI());
        return new TorrentFileSet(file, this.temporaryFolder.newFolder());
    }

    @Test
    public void testSingleFileTorrentFile() throws Exception {
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertEquals((String)"Should have had a single file info", (long)1L, (long)cut.getFiles().size());
        Assert.assertEquals((String)"Piece size has not been correctly copied from the metadata", (long)262144L, (long)cut.getPieceSize());
        FileInfo fileInfo = (FileInfo)cut.getFiles().get(0);
        Assert.assertEquals((String)"Filename should have been gimp-2.8.16-setup-1.exe", (Object)"gimp-2.8.16-setup-1.exe", (Object)fileInfo.getFileName());
        Assert.assertEquals((String)"Filesize should have been 743440384", (long)96823808L, (long)fileInfo.getSize());
        Assert.assertEquals((String)"Piece count should have been 1418", (long)370L, (long)fileInfo.getPieceCount());
        Assert.assertEquals((String)"First byte offset should have been 0", (long)0L, (long)fileInfo.getFirstByteOffset());
        try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(new FileInputStream(new File(TorrentFileSetTest.class.getResource("gimp-2.8.16-setup-1.exe.torrent.hashes").toURI()))));){
            for (Piece piece : cut.pieces) {
                String pieceHash = inputStream.readLine();
                byte[] pieceHashBytes = (byte[])Whitebox.getInternalState((Object)piece, (String)"expectedHash");
                Assert.assertEquals((String)String.format("Piece %d hash should have matched the one in the .hashes file", piece.getIndex()), (Object)pieceHash, (Object)StringUtils.byteArrayToString((byte[])pieceHashBytes));
            }
        }
        Assert.assertEquals((String)"Incorrect amount of bytes to cover all pieces", (long)47L, (long)cut.getBitfieldBytes().length);
        Assert.assertEquals((String)"Incorrect amount of blocks in first piece", (long)16L, (long)cut.getPiece(0).getBlockCount());
        Assert.assertEquals((String)"Incorrect amount of blocks in last piece", (long)6L, (long)cut.getPiece(cut.getPieceCount() - 1).getBlockCount());
    }

    @Test
    public void testMultiFileTorrentFile() throws Exception {
        TorrentFileSet cut = this.getMultiFileTorrent();
        Assert.assertEquals((String)"Should have had a single file info", (long)6L, (long)cut.getFiles().size());
        String[] fileNames = new String[]{"apache_2.2.9-win32-x86-openssl-0.9.8h-r2.msi", "HowToInstallGuide.txt", "httpd.conf", "mysql-essential-5.0.51b-win32.msi", "npp.5.6.8.Installer.exe", "php-5.3.2-src.zip"};
        long[] fileSizes = new long[]{5414400L, 547L, 18124L, 23816192L, 3336170L, 19823435L};
        int[] pieceCounts = new int[]{83, 1, 1, 365, 52, 304};
        long[] firstByteOffsets = new long[]{0L, 5414400L, 5414947L, 5433071L, 29249263L, 32585433L};
        for (int i = 0; i < cut.getFiles().size(); ++i) {
            FileInfo fileInfo = (FileInfo)cut.getFiles().get(i);
            Assert.assertEquals((String)String.format("Incorrect filename for entry %d", i), (Object)fileNames[i], (Object)fileInfo.getFileName());
            Assert.assertEquals((String)String.format("Incorrect file size for entry %d", i), (long)fileSizes[i], (long)fileInfo.getSize());
            Assert.assertEquals((String)String.format("Incorrect piece count for entry %d", i), (long)pieceCounts[i], (long)fileInfo.getPieceCount());
            Assert.assertEquals((String)String.format("Incorrect first byte offset for entry %d", i), (long)firstByteOffsets[i], (long)fileInfo.getFirstByteOffset());
        }
        try (BufferedReader inputStream = new BufferedReader(new InputStreamReader(new FileInputStream(new File(TorrentFileSetTest.class.getResource("my.sql.apache.2.2.php.notepad.torrent.hashes").toURI()))));){
            for (Piece piece : cut.pieces) {
                String pieceHash = inputStream.readLine();
                byte[] pieceHashBytes = (byte[])Whitebox.getInternalState((Object)piece, (String)"expectedHash");
                Assert.assertEquals((String)String.format("Piece %d hash should have matched the one in the .hashes file", piece.getIndex()), (Object)pieceHash, (Object)StringUtils.byteArrayToString((byte[])pieceHashBytes));
            }
        }
        Assert.assertEquals((String)"Incorrect amount of bytes to cover all pieces", (long)100L, (long)cut.getBitfieldBytes().length);
    }

    @Test
    public void testGetFileForBytes() throws Exception {
        TorrentFileSet cut = this.getMultiFileTorrent();
        Assert.assertEquals((String)"Incorrect block size. Even though the protocol allows it, many clients don't respond on any other size than 1 << 14", (long)16384L, (long)cut.getBlockSize());
        Assert.assertEquals((String)"Incorrect file info got returned for the first byte", cut.getFiles().get(0), (Object)cut.getFileForBytes(0, 0, 0));
        Assert.assertEquals((String)"Incorrect info got returned for the last byte in the first file", cut.getFiles().get(0), (Object)cut.getFileForBytes(82, 2, 7679));
        Assert.assertEquals((String)"Incorrect file info got returned for the first byte in the second file", cut.getFiles().get(1), (Object)cut.getFileForBytes(82, 2, 7680));
    }

    @Test
    public void testGetFileForBytesNegativePiece() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Piece");
        TorrentFileSet cut = this.getSingleFileTorrent();
        cut.getFileForBytes(-1, 0, 0);
    }

    @Test
    public void testGetFileForBytesNegativeBlock() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Block");
        TorrentFileSet cut = this.getSingleFileTorrent();
        cut.getFileForBytes(0, -1, 0);
    }

    @Test
    public void testGetFileForBytesNegativeByteOffset() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Byte");
        TorrentFileSet cut = this.getSingleFileTorrent();
        cut.getFileForBytes(0, 0, -1);
    }

    @Test
    public void testGetFileForBytesOutOfRangePiece() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Piece");
        TorrentFileSet cut = this.getSingleFileTorrent();
        cut.getFileForBytes(Integer.MAX_VALUE, 0, 0);
    }

    @Test
    public void testGetFileForBytesOutOfRangeBlock() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Block");
        TorrentFileSet cut = this.getSingleFileTorrent();
        cut.getFileForBytes(0, Integer.MAX_VALUE, 0);
    }

    @Test
    public void testGetFileForBytesOutOfRangeByteOffset() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Byte");
        TorrentFileSet cut = this.getSingleFileTorrent();
        cut.getFileForBytes(0, 0, Integer.MAX_VALUE);
    }

    @Test
    public void testConstructorNonExistingTorrent() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Torrent file");
        new TorrentFileSet(new File("dfagsdfasjghfh.torrent"), new File("fdafsd"));
    }

    @Test
    public void testConstructorNullTorrent() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Torrent file");
        new TorrentFileSet(null, null);
    }

    @Test
    public void testConstructorNullDownloadFolder() throws Exception {
        File file = new File(TorrentFileSetTest.class.getResource(MULTI_FILE_TORRENT).toURI());
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Download folder");
        new TorrentFileSet(file, null);
    }

    @Test
    public void testSetHavingPiece() throws Exception {
        TorrentFileSet cut = this.getSingleFileTorrent();
        byte[] expectedBitfield = new byte[47];
        Assert.assertFalse((String)"Piece is completed before interaction.", (boolean)cut.hasPiece(1));
        Assert.assertArrayEquals((String)"Bitfield is dirty before interaction.", (byte[])expectedBitfield, (byte[])cut.getBitfieldBytes());
        cut.setHavingPiece(1);
        expectedBitfield[0] = 64;
        Assert.assertTrue((String)"Piece is not completed after interaction.", (boolean)cut.hasPiece(1));
        Assert.assertArrayEquals((String)"Bitfield has incorrect been altered by interaction.", (byte[])expectedBitfield, (byte[])cut.getBitfieldBytes());
    }

    @Test
    public void testHasPieceLowerBound() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Piece");
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertFalse((String)"Piece 0 is not yet done.", (boolean)cut.hasPiece(0));
        cut.hasPiece(-1);
    }

    @Test
    public void testHasPieceUpperBound() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Piece");
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertFalse((String)"Piece is not yet done.", (boolean)cut.hasPiece(cut.getPieceCount() - 1));
        cut.hasPiece(cut.getPieceCount());
    }

    @Test
    public void testGetPieceLowerBound() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Piece");
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertNotNull((String)"Piece 0 is not yet done.", (Object)cut.getPiece(0));
        cut.getPiece(-1);
    }

    @Test
    public void testGetPieceUpperBound() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Piece");
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertNotNull((String)"Piece is not yet done.", (Object)cut.getPiece(cut.getPieceCount() - 1));
        cut.getPiece(cut.getPieceCount());
    }

    @Test
    public void testGetTotalFileSize() throws Exception {
        TorrentFileSet cut = this.getMultiFileTorrent();
        Assert.assertEquals((String)"Incorrect total size", (long)52408868L, (long)cut.getTotalFileSize());
    }

    @Test
    public void testCountRemainingBytes() throws Exception {
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertEquals((String)"All bytes should have been remaining", (long)96823808L, (long)cut.countRemainingBytes());
    }

    @Test
    public void testCountCompletedPieces() throws Exception {
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertEquals((String)"No piece should have been downloaded", (long)0L, (long)cut.countCompletedPieces());
    }

    @Test
    public void testIsDone() throws Exception {
        TorrentFileSet cut = this.getSingleFileTorrent();
        Assert.assertFalse((String)"Should not have been done yet.", (boolean)cut.isDone());
        Assert.assertEquals((String)"All pieces should have been needed", (long)cut.getPieceCount(), (long)cut.getNeededPieces().count());
        for (int i = 0; i < cut.getPieceCount(); ++i) {
            cut.setHavingPiece(i);
        }
        Assert.assertTrue((String)"Should have been done yet.", (boolean)cut.isDone());
        Assert.assertEquals((String)"None of the pieces should have been needed", (long)0L, (long)cut.getNeededPieces().count());
    }
}

