/*
 * Decompiled with CFR 0.152.
 */
package org.johnnei.javatorrent.torrent;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.johnnei.javatorrent.TorrentClient;
import org.johnnei.javatorrent.bittorrent.protocol.messages.IMessage;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageBitfield;
import org.johnnei.javatorrent.bittorrent.protocol.messages.MessageHave;
import org.johnnei.javatorrent.disk.DiskJobCheckHash;
import org.johnnei.javatorrent.disk.DiskJobWriteBlock;
import org.johnnei.javatorrent.disk.IDiskJob;
import org.johnnei.javatorrent.module.IModule;
import org.johnnei.javatorrent.network.BitTorrentSocket;
import org.johnnei.javatorrent.test.DummyEntity;
import org.johnnei.javatorrent.test.TestUtils;
import org.johnnei.javatorrent.torrent.AbstractFileSet;
import org.johnnei.javatorrent.torrent.MetadataFileSet;
import org.johnnei.javatorrent.torrent.Torrent;
import org.johnnei.javatorrent.torrent.TorrentFileSet;
import org.johnnei.javatorrent.torrent.algos.pieceselector.IPieceSelector;
import org.johnnei.javatorrent.torrent.files.BlockStatus;
import org.johnnei.javatorrent.torrent.files.Piece;
import org.johnnei.javatorrent.torrent.peer.Peer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.powermock.reflect.Whitebox;

public class TorrentTest
extends EasyMockSupport {
    private static final String METADATA_FILE = "gimp-2.8.16-setup-1.exe.torrent";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSetGetPieceSelector() {
        Torrent cut = DummyEntity.createUniqueTorrent(new Torrent[0]);
        IPieceSelector selector = p -> Optional.empty();
        Assert.assertNotEquals((String)"Selector should not be equal before setting", (Object)selector, (Object)cut.getPieceSelector());
        cut.setPieceSelector(selector);
        Assert.assertEquals((String)"Selector should not be equal before setting", (Object)selector, (Object)cut.getPieceSelector());
    }

    @Test
    public void testEquality() {
        Torrent base = DummyEntity.createUniqueTorrent(new Torrent[0]);
        Torrent notEqual = DummyEntity.createUniqueTorrent(base);
        Torrent equal = new Torrent.Builder().setName("Torrent").setHash(base.getHashArray()).build();
        TestUtils.assertEqualityMethods(base, equal, notEqual);
    }

    @Test
    public void testAddDiskJob() {
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        torrentClientMock.addDiskJob((IDiskJob)EasyMock.notNull());
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("Add Disk Job Test").setTorrentClient(torrentClientMock).build();
        cut.addDiskJob((IDiskJob)new DiskJobCheckHash(pieceMock, job -> {}));
        this.verifyAll();
    }

    @Test
    public void testCheckForProgress() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        Piece pieceMockOne = (Piece)this.createMock(Piece.class);
        Piece pieceMockTwo = (Piece)this.createMock(Piece.class);
        Piece pieceMockThree = (Piece)this.createMock(Piece.class);
        EasyMock.expect((Object)fileSetMock.getNeededPieces()).andReturn(Arrays.asList(pieceMockOne, pieceMockTwo, pieceMockThree).stream());
        EasyMock.expect((Object)pieceMockOne.checkHash()).andReturn((Object)true);
        EasyMock.expect((Object)pieceMockOne.getIndex()).andReturn((Object)0).atLeastOnce();
        EasyMock.expect((Object)pieceMockTwo.checkHash()).andReturn((Object)false);
        EasyMock.expect((Object)pieceMockThree.checkHash()).andThrow((Throwable)new IOException("Test Check For Progress IO Exception"));
        EasyMock.expect((Object)pieceMockThree.getIndex()).andReturn((Object)2).atLeastOnce();
        fileSetMock.setHavingPiece(EasyMock.eq((int)0));
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMock.getBitTorrentSocket()).andStubReturn((Object)socketMock);
        socketMock.setPassedHandshake();
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageHave.class));
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        EasyMock.expect((Object)torrentClientMock.getModules()).andStubReturn(Collections.emptyList());
        this.replayAll();
        Torrent cut = new Torrent.Builder().setTorrentClient(torrentClientMock).setName("Check for progress test").build();
        cut.setFileSet(fileSetMock);
        cut.addPeer(peerMock);
        cut.checkProgress();
        this.verifyAll();
    }

    @Test
    public void testSeederLeecherCount() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)fileSetMock.getPieceCount()).andReturn((Object)5).atLeastOnce();
        MetadataFileSet metadataMock = (MetadataFileSet)this.createMock(MetadataFileSet.class);
        EasyMock.expect((Object)metadataMock.isDone()).andReturn((Object)true).atLeastOnce();
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMock.getBitTorrentSocket()).andStubReturn((Object)socketMock);
        EasyMock.expect((Object)peerMock.countHavePieces()).andReturn((Object)5).atLeastOnce();
        socketMock.setPassedHandshake();
        BitTorrentSocket socketMockTwo = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peerMockTwo = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMockTwo.getBitTorrentSocket()).andStubReturn((Object)socketMockTwo);
        EasyMock.expect((Object)peerMockTwo.countHavePieces()).andReturn((Object)3).atLeastOnce();
        socketMockTwo.setPassedHandshake();
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        EasyMock.expect((Object)torrentClientMock.getModules()).andStubReturn(Collections.emptyList());
        this.replayAll();
        Torrent cut = new Torrent.Builder().setTorrentClient(torrentClientMock).setName("Upload/Download rates test").build();
        cut.addPeer(peerMock);
        cut.addPeer(peerMockTwo);
        Assert.assertEquals((String)"All peers should be leechers at this point.", (long)2L, (long)cut.getLeecherCount());
        Assert.assertEquals((String)"We don't know if any peers are seeders yet.", (long)0L, (long)cut.getSeedCount());
        cut.setMetadata(metadataMock);
        cut.setFileSet(fileSetMock);
        Assert.assertEquals((String)"All peers should be leechers at this point.", (long)1L, (long)cut.getLeecherCount());
        Assert.assertEquals((String)"We don't know if any peers are seeders yet.", (long)1L, (long)cut.getSeedCount());
        this.verifyAll();
    }

    @Test
    public void testUploadDownloadRates() throws Exception {
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMock.getBitTorrentSocket()).andStubReturn((Object)socketMock);
        EasyMock.expect((Object)socketMock.getDownloadRate()).andReturn((Object)5);
        EasyMock.expect((Object)socketMock.getUploadRate()).andReturn((Object)3);
        socketMock.pollRates();
        socketMock.setPassedHandshake();
        BitTorrentSocket socketMockTwo = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peerMockTwo = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMockTwo.getBitTorrentSocket()).andStubReturn((Object)socketMockTwo);
        EasyMock.expect((Object)socketMockTwo.getDownloadRate()).andReturn((Object)10);
        EasyMock.expect((Object)socketMockTwo.getUploadRate()).andReturn((Object)13);
        socketMockTwo.pollRates();
        socketMockTwo.setPassedHandshake();
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        EasyMock.expect((Object)torrentClientMock.getModules()).andStubReturn(Collections.emptyList());
        this.replayAll();
        Torrent cut = new Torrent.Builder().setTorrentClient(torrentClientMock).setName("Upload/Download rates test").build();
        cut.addPeer(peerMock);
        cut.addPeer(peerMockTwo);
        cut.pollRates();
        Assert.assertEquals((String)"Download speed aren't added up correctly", (long)15L, (long)cut.getDownloadRate());
        Assert.assertEquals((String)"Upload speed aren't added up correctly", (long)16L, (long)cut.getUploadRate());
        this.verifyAll();
    }

    @Test
    public void testOnReceivedBlockChechHashMismatch() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        MetadataFileSet metadataMock = (MetadataFileSet)this.createMock(MetadataFileSet.class);
        TorrentClient torrentClient = (TorrentClient)this.createMock(TorrentClient.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        Capture writeJobCapture = EasyMock.newCapture();
        Capture checkHashCapture = EasyMock.newCapture();
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock).atLeastOnce();
        EasyMock.expect((Object)pieceMock.getBlockSize(EasyMock.eq((int)1))).andReturn((Object)15);
        pieceMock.onHashMismatch();
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobWriteBlock.class), (Object)EasyMock.capture((Capture)writeJobCapture)));
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobCheckHash.class), (Object)EasyMock.capture((Capture)checkHashCapture)));
        pieceMock.storeBlock(EasyMock.eq((int)1), EasyMock.aryEq((byte[])new byte[15]));
        pieceMock.setBlockStatus(EasyMock.eq((int)1), (BlockStatus)EasyMock.eq((Object)BlockStatus.Stored));
        EasyMock.expect((Object)pieceMock.checkHash()).andReturn((Object)false);
        EasyMock.expect((Object)pieceMock.countBlocksWithStatus((BlockStatus)EasyMock.eq((Object)BlockStatus.Stored))).andReturn((Object)2);
        EasyMock.expect((Object)pieceMock.getBlockCount()).andReturn((Object)2);
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("On Received Block Test").setTorrentClient(torrentClient).build();
        cut.setFileSet(fileSetMock);
        cut.setMetadata(metadataMock);
        cut.onReceivedBlock(fileSetMock, 0, 15, new byte[15]);
        ((IDiskJob)writeJobCapture.getValue()).process();
        ((IDiskJob)checkHashCapture.getValue()).process();
        this.verifyAll();
    }

    @Test
    public void testOnReceivedBlockChechHash() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        MetadataFileSet metadataMock = (MetadataFileSet)this.createMock(MetadataFileSet.class);
        TorrentClient torrentClient = (TorrentClient)this.createMock(TorrentClient.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        Capture writeJobCapture = EasyMock.newCapture();
        Capture checkHashCapture = EasyMock.newCapture();
        EasyMock.expect((Object)metadataMock.isDone()).andReturn((Object)true).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock).atLeastOnce();
        EasyMock.expect((Object)pieceMock.getBlockSize(EasyMock.eq((int)1))).andReturn((Object)15);
        EasyMock.expect((Object)pieceMock.getIndex()).andReturn((Object)1).atLeastOnce();
        EasyMock.expect((Object)pieceMock.getSize()).andReturn((Object)15);
        fileSetMock.setHavingPiece(EasyMock.eq((int)1));
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobWriteBlock.class), (Object)EasyMock.capture((Capture)writeJobCapture)));
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobCheckHash.class), (Object)EasyMock.capture((Capture)checkHashCapture)));
        EasyMock.expect((Object)torrentClient.getModules()).andReturn(Collections.emptyList());
        pieceMock.storeBlock(EasyMock.eq((int)1), EasyMock.aryEq((byte[])new byte[15]));
        pieceMock.setBlockStatus(EasyMock.eq((int)1), (BlockStatus)EasyMock.eq((Object)BlockStatus.Stored));
        EasyMock.expect((Object)pieceMock.checkHash()).andReturn((Object)true);
        EasyMock.expect((Object)pieceMock.countBlocksWithStatus((BlockStatus)EasyMock.eq((Object)BlockStatus.Stored))).andReturn((Object)2);
        EasyMock.expect((Object)pieceMock.getBlockCount()).andReturn((Object)2);
        BitTorrentSocket socketMock = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        Peer peerMock = (Peer)this.createMock(Peer.class);
        EasyMock.expect((Object)peerMock.getBitTorrentSocket()).andStubReturn((Object)socketMock);
        socketMock.setPassedHandshake();
        EasyMock.expect((Object)fileSetMock.countCompletedPieces()).andReturn((Object)0);
        socketMock.enqueueMessage((IMessage)EasyMock.isA(MessageHave.class));
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("On Received Block Test").setTorrentClient(torrentClient).build();
        cut.setFileSet(fileSetMock);
        cut.setMetadata(metadataMock);
        cut.addPeer(peerMock);
        cut.onReceivedBlock(fileSetMock, 0, 15, new byte[15]);
        Assert.assertEquals((String)"Incorrect downloaded bytes, nothing is completed yet.", (long)0L, (long)cut.getDownloadedBytes());
        ((IDiskJob)writeJobCapture.getValue()).process();
        ((IDiskJob)checkHashCapture.getValue()).process();
        Assert.assertEquals((String)"Incorrect downloaded bytes, piece size should have been added.", (long)15L, (long)cut.getDownloadedBytes());
        this.verifyAll();
    }

    @Test
    public void testOnReceivedBlockIncorrectSize() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        TorrentClient torrentClient = (TorrentClient)this.createMock(TorrentClient.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock).atLeastOnce();
        EasyMock.expect((Object)pieceMock.getBlockSize(EasyMock.eq((int)1))).andReturn((Object)10);
        pieceMock.setBlockStatus(EasyMock.eq((int)1), (BlockStatus)EasyMock.eq((Object)BlockStatus.Needed));
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("On Received Block Test").setTorrentClient(torrentClient).build();
        cut.setFileSet(fileSetMock);
        cut.onReceivedBlock(fileSetMock, 0, 15, new byte[15]);
        this.verifyAll();
    }

    @Test
    public void testOnReceivedBlockPieceNotDone() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        TorrentClient torrentClient = (TorrentClient)this.createMock(TorrentClient.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        Capture writeJobCapture = EasyMock.newCapture();
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock).atLeastOnce();
        EasyMock.expect((Object)pieceMock.getBlockSize(EasyMock.eq((int)1))).andReturn((Object)15);
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobWriteBlock.class), (Object)EasyMock.capture((Capture)writeJobCapture)));
        pieceMock.storeBlock(EasyMock.eq((int)1), EasyMock.aryEq((byte[])new byte[15]));
        pieceMock.setBlockStatus(EasyMock.eq((int)1), (BlockStatus)EasyMock.eq((Object)BlockStatus.Stored));
        EasyMock.expect((Object)pieceMock.countBlocksWithStatus((BlockStatus)EasyMock.eq((Object)BlockStatus.Stored))).andReturn((Object)1);
        EasyMock.expect((Object)pieceMock.getBlockCount()).andReturn((Object)2);
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("On Received Block Test").setTorrentClient(torrentClient).build();
        cut.setFileSet(fileSetMock);
        cut.onReceivedBlock(fileSetMock, 0, 15, new byte[15]);
        ((IDiskJob)writeJobCapture.getValue()).process();
        this.verifyAll();
    }

    @Test
    public void testOnReceivedBlockChechHashDownloadingMetadata() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        TorrentClient torrentClient = (TorrentClient)this.createMock(TorrentClient.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        MetadataFileSet metadataMock = (MetadataFileSet)this.createMock(MetadataFileSet.class);
        Capture writeJobCapture = EasyMock.newCapture();
        Capture checkHashCapture = EasyMock.newCapture();
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock).atLeastOnce();
        EasyMock.expect((Object)pieceMock.getBlockSize(EasyMock.eq((int)1))).andReturn((Object)15);
        EasyMock.expect((Object)pieceMock.getIndex()).andStubReturn((Object)0);
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobWriteBlock.class), (Object)EasyMock.capture((Capture)writeJobCapture)));
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobCheckHash.class), (Object)EasyMock.capture((Capture)checkHashCapture)));
        pieceMock.storeBlock(EasyMock.eq((int)1), EasyMock.aryEq((byte[])new byte[15]));
        pieceMock.setBlockStatus(EasyMock.eq((int)1), (BlockStatus)EasyMock.eq((Object)BlockStatus.Stored));
        EasyMock.expect((Object)pieceMock.countBlocksWithStatus((BlockStatus)EasyMock.eq((Object)BlockStatus.Stored))).andReturn((Object)2);
        EasyMock.expect((Object)pieceMock.getBlockCount()).andReturn((Object)2);
        EasyMock.expect((Object)pieceMock.checkHash()).andReturn((Object)true);
        metadataMock.setHavingPiece(EasyMock.eq((int)0));
        EasyMock.expect((Object)metadataMock.isDone()).andReturn((Object)false);
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("On Received Block Test").setTorrentClient(torrentClient).build();
        cut.setFileSet(fileSetMock);
        cut.setMetadata(metadataMock);
        cut.onReceivedBlock(fileSetMock, 0, 15, new byte[15]);
        ((IDiskJob)writeJobCapture.getValue()).process();
        ((IDiskJob)checkHashCapture.getValue()).process();
        this.verifyAll();
    }

    @Test
    public void testOnReceivedBlock() throws Exception {
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        TorrentClient torrentClient = (TorrentClient)this.createMock(TorrentClient.class);
        Piece pieceMock = (Piece)this.createMock(Piece.class);
        Capture writeJobCapture = EasyMock.newCapture();
        Capture checkHashCapture = EasyMock.newCapture();
        EasyMock.expect((Object)fileSetMock.getBlockSize()).andReturn((Object)15);
        EasyMock.expect((Object)fileSetMock.getPiece(EasyMock.eq((int)0))).andReturn((Object)pieceMock).atLeastOnce();
        EasyMock.expect((Object)pieceMock.getBlockSize(EasyMock.eq((int)1))).andReturn((Object)15);
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobWriteBlock.class), (Object)EasyMock.capture((Capture)writeJobCapture)));
        torrentClient.addDiskJob((IDiskJob)EasyMock.and((Object)EasyMock.isA(DiskJobCheckHash.class), (Object)EasyMock.capture((Capture)checkHashCapture)));
        pieceMock.storeBlock(EasyMock.eq((int)1), EasyMock.aryEq((byte[])new byte[15]));
        pieceMock.setBlockStatus(EasyMock.eq((int)1), (BlockStatus)EasyMock.eq((Object)BlockStatus.Stored));
        EasyMock.expect((Object)pieceMock.countBlocksWithStatus((BlockStatus)EasyMock.eq((Object)BlockStatus.Stored))).andReturn((Object)2);
        EasyMock.expect((Object)pieceMock.getBlockCount()).andReturn((Object)2);
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("On Received Block Test").setTorrentClient(torrentClient).build();
        cut.setFileSet(fileSetMock);
        cut.onReceivedBlock(fileSetMock, 0, 15, new byte[15]);
        ((IDiskJob)writeJobCapture.getValue()).process();
        this.verifyAll();
    }

    @Test
    public void testGetHash() {
        Torrent cut = DummyEntity.createUniqueTorrent(new Torrent[0]);
        Assert.assertTrue((String)"Incorrect hash output", (boolean)cut.getHash().matches("^[a-fA-F0-9]{40}$"));
    }

    @Test
    public void testToString() {
        Torrent cut = DummyEntity.createUniqueTorrent(new Torrent[0]);
        Assert.assertTrue((String)"Incorrect toString start", (boolean)cut.toString().startsWith("Torrent["));
    }

    @Test
    public void testAddRemovePeer() throws Exception {
        byte[] peerId = DummyEntity.createUniquePeerId(new byte[0][]);
        byte[] peerIdTwo = DummyEntity.createUniquePeerId(new byte[][]{peerId});
        BitTorrentSocket socketMockOne = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        socketMockOne.setPassedHandshake();
        BitTorrentSocket socketMockTwo = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        socketMockTwo.setPassedHandshake();
        BitTorrentSocket socketMockThree = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        socketMockThree.close();
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        EasyMock.expect((Object)torrentClientMock.getModules()).andStubReturn(Collections.emptyList());
        Peer peerMock = (Peer)this.createMockBuilder(Peer.class).addMockedMethod("discardAllBlockRequests").createMock();
        Whitebox.setInternalState((Object)peerMock, (String)"id", (Object)peerIdTwo);
        peerMock.discardAllBlockRequests();
        this.replayAll();
        Torrent cut = DummyEntity.createUniqueTorrent(torrentClientMock, new Torrent[0]);
        Peer peerOne = new Peer.Builder().setSocket(socketMockOne).setTorrent(cut).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerId).build();
        Peer peerThree = new Peer.Builder().setSocket(socketMockThree).setTorrent(cut).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerId).build();
        Peer peerTwo = new Peer.Builder().setSocket(socketMockTwo).setTorrent(cut).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerIdTwo).build();
        Assert.assertEquals((String)"Peer list should be empty", (long)0L, (long)cut.getPeers().size());
        cut.addPeer(peerOne);
        Assert.assertEquals((String)"Peer one should have been added to the list.", (long)1L, (long)cut.getPeers().size());
        Assert.assertTrue((String)"Peer one should have been added to the list.", (boolean)cut.getPeers().contains(peerOne));
        cut.addPeer(peerThree);
        Assert.assertEquals((String)"Peer three should not have been added to the list twice.", (long)1L, (long)cut.getPeers().size());
        Assert.assertFalse((String)"Peer three should not be present in the list.", (boolean)cut.getPeers().stream().anyMatch(p -> p == peerThree));
        cut.addPeer(peerTwo);
        Assert.assertEquals((String)"Peer two should have been added to the list.", (long)2L, (long)cut.getPeers().size());
        Assert.assertTrue((String)"Peer two should have been added to the list.", (boolean)cut.getPeers().contains(peerTwo));
        cut.removePeer(peerMock);
        Assert.assertEquals((String)"Peer two should have been removed from the list.", (long)1L, (long)cut.getPeers().size());
        Assert.assertFalse((String)"Peer two should have been removed to the list.", (boolean)cut.getPeers().contains(peerTwo));
        cut.removePeer(peerTwo);
        Assert.assertEquals((String)"Removal of peer two twice should not affect the list on the second attempt.", (long)1L, (long)cut.getPeers().size());
        this.verifyAll();
    }

    private MetadataFileSet createCompletedMetadataFileSet(Torrent torrent) throws Exception {
        File file = new File(TorrentTest.class.getResource(METADATA_FILE).toURI());
        MetadataFileSet metadataFileSet = new MetadataFileSet(torrent, file);
        metadataFileSet.getNeededPieces().forEach(p -> metadataFileSet.setHavingPiece(p.getIndex()));
        return metadataFileSet;
    }

    @Test
    public void testSendHaveMessagesNoMessages() throws Exception {
        byte[] peerId = DummyEntity.createUniquePeerId(new byte[0][]);
        BitTorrentSocket socketMockOne = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        socketMockOne.setPassedHandshake();
        TorrentFileSet fileSetMock = (TorrentFileSet)this.createMock(TorrentFileSet.class);
        EasyMock.expect((Object)fileSetMock.countCompletedPieces()).andReturn((Object)0).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andReturn((Object)new byte[0]);
        IModule moduleMock = (IModule)this.createMock(IModule.class);
        moduleMock.onPostHandshake((Peer)EasyMock.notNull());
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        EasyMock.expect((Object)torrentClientMock.getModules()).andStubReturn(Collections.singletonList(moduleMock));
        this.replayAll();
        Torrent cut = DummyEntity.createUniqueTorrent(torrentClientMock, new Torrent[0]);
        cut.setMetadata(this.createCompletedMetadataFileSet(cut));
        cut.setFileSet((AbstractFileSet)fileSetMock);
        Peer peer = new Peer.Builder().setSocket(socketMockOne).setTorrent(cut).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerId).build();
        cut.addPeer(peer);
        this.verifyAll();
    }

    @Test
    public void testSendHaveMessagesSendBitfield() throws Exception {
        byte[] peerId = DummyEntity.createUniquePeerId(new byte[0][]);
        BitTorrentSocket socketMockOne = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        socketMockOne.setPassedHandshake();
        socketMockOne.enqueueMessage((IMessage)EasyMock.isA(MessageBitfield.class));
        TorrentFileSet fileSetMock = (TorrentFileSet)this.createMock(TorrentFileSet.class);
        EasyMock.expect((Object)fileSetMock.countCompletedPieces()).andReturn((Object)7).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andReturn((Object)new byte[2]).atLeastOnce();
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        EasyMock.expect((Object)torrentClientMock.getModules()).andReturn(Collections.emptyList());
        this.replayAll();
        Torrent cut = DummyEntity.createUniqueTorrent(torrentClientMock, new Torrent[0]);
        cut.setMetadata(this.createCompletedMetadataFileSet(cut));
        cut.setFileSet((AbstractFileSet)fileSetMock);
        Peer peer = new Peer.Builder().setSocket(socketMockOne).setTorrent(cut).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerId).build();
        cut.addPeer(peer);
        this.verifyAll();
    }

    @Test
    public void testSendHaveMessagesSendHaveMessages() throws Exception {
        byte[] peerId = DummyEntity.createUniquePeerId(new byte[0][]);
        Capture haveCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        BitTorrentSocket socketMockOne = (BitTorrentSocket)this.createMock(BitTorrentSocket.class);
        socketMockOne.setPassedHandshake();
        socketMockOne.enqueueMessage((IMessage)EasyMock.capture((Capture)haveCapture));
        socketMockOne.enqueueMessage((IMessage)EasyMock.capture((Capture)haveCapture));
        TorrentFileSet fileSetMock = (TorrentFileSet)this.createMock(TorrentFileSet.class);
        EasyMock.expect((Object)fileSetMock.countCompletedPieces()).andReturn((Object)2).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getBitfieldBytes()).andReturn((Object)new byte[12]).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.getPieceCount()).andReturn((Object)96).atLeastOnce();
        EasyMock.expect((Object)fileSetMock.hasPiece(0)).andReturn((Object)true);
        EasyMock.expect((Object)fileSetMock.hasPiece(5)).andReturn((Object)true);
        EasyMock.expect((Object)fileSetMock.hasPiece(EasyMock.anyInt())).andReturn((Object)false).times(94);
        TorrentClient torrentClientMock = (TorrentClient)this.createMock(TorrentClient.class);
        EasyMock.expect((Object)torrentClientMock.getModules()).andStubReturn(Collections.emptyList());
        this.replayAll();
        Torrent cut = DummyEntity.createUniqueTorrent(torrentClientMock, new Torrent[0]);
        cut.setMetadata(this.createCompletedMetadataFileSet(cut));
        cut.setFileSet((AbstractFileSet)fileSetMock);
        Peer peer = new Peer.Builder().setSocket(socketMockOne).setTorrent(cut).setExtensionBytes(DummyEntity.createRandomBytes(8)).setId(peerId).build();
        cut.addPeer(peer);
        this.verifyAll();
        ArrayList<Integer> expectedPieces = new ArrayList<Integer>();
        expectedPieces.add(0);
        expectedPieces.add(5);
        for (MessageHave message : haveCapture.getValues()) {
            expectedPieces.remove(Whitebox.getInternalState((Object)message, (String)"pieceIndex"));
        }
        Assert.assertEquals((String)"All pieces marked as have should have been send as have message", (long)0L, (long)expectedPieces.size());
    }

    @Test
    public void testBuilderCanDownload() {
        Torrent.Builder builder = new Torrent.Builder();
        Assert.assertFalse((String)"Torrent should not be downloadable yet", (boolean)builder.canDownload());
        builder.setName("Can download");
        Assert.assertFalse((String)"Torrent should not be downloadable yet", (boolean)builder.canDownload());
        builder.setHash(DummyEntity.createRandomBytes(20));
        Assert.assertTrue((String)"Torrent should not be downloadable yet", (boolean)builder.canDownload());
    }

    @Test
    public void testGetDisplayName() {
        Torrent cut = new Torrent.Builder().setName("Test").setHash(DummyEntity.createUniqueTorrentHash(new byte[0][])).build();
        Assert.assertEquals((String)"Incorrect display name", (Object)"Test", (Object)cut.getDisplayName());
    }

    @Test
    public void testGetUploadedBytes() {
        Torrent cut = new Torrent.Builder().setName("Test").setHash(DummyEntity.createUniqueTorrentHash(new byte[0][])).build();
        Assert.assertEquals((String)"Incorrect amount of uploaded bytes, nothing is uploaded", (long)0L, (long)cut.getUploadedBytes());
        cut.addUploadedBytes(15L);
        Assert.assertEquals((String)"Incorrect amount of uploaded bytes, data has been uploaded", (long)15L, (long)cut.getUploadedBytes());
    }

    @Test
    public void testGetMetadata() {
        MetadataFileSet metadataFileSetMock = (MetadataFileSet)this.createMock(MetadataFileSet.class);
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("Test").setHash(DummyEntity.createUniqueTorrentHash(new byte[0][])).build();
        TestUtils.assertNotPresent("Metadata has not been set yet", cut.getMetadata());
        cut.setMetadata(metadataFileSetMock);
        TestUtils.assertPresent("Metadata has been set", cut.getMetadata());
        Assert.assertTrue((String)"Metadata should be the same reference as the one set.", (metadataFileSetMock == cut.getMetadata().get() ? 1 : 0) != 0);
        this.verifyAll();
    }

    @Test
    public void testIsDownloadingMetadata() {
        MetadataFileSet metadataFileSetMock = (MetadataFileSet)this.createMock(MetadataFileSet.class);
        AbstractFileSet fileSetMock = (AbstractFileSet)this.createMock(AbstractFileSet.class);
        EasyMock.expect((Object)metadataFileSetMock.isDone()).andReturn((Object)false);
        EasyMock.expect((Object)metadataFileSetMock.isDone()).andStubReturn((Object)true);
        this.replayAll();
        Torrent cut = new Torrent.Builder().setName("Test").setHash(DummyEntity.createUniqueTorrentHash(new byte[0][])).build();
        Assert.assertTrue((String)"Metadata has not been set yet", (boolean)cut.isDownloadingMetadata());
        cut.setMetadata(metadataFileSetMock);
        Assert.assertTrue((String)"Metadata should have returned that it is not done yet", (boolean)cut.isDownloadingMetadata());
        Assert.assertTrue((String)"Metadata should have returned that it is done, but the torrent fileset has not been set yet.", (boolean)cut.isDownloadingMetadata());
        cut.setFileSet(fileSetMock);
        Assert.assertFalse((String)"Metadata should have returned that it is done", (boolean)cut.isDownloadingMetadata());
        this.verifyAll();
    }

    @Test
    public void testBuildFromMetadataFile() throws Exception {
        Torrent torrent = new Torrent.Builder().setName("GIMP Torrent file").buildFromMetata(new File(TorrentTest.class.getResource(METADATA_FILE).toURI()), this.temporaryFolder.newFolder());
        Assert.assertTrue((String)"Metadata was supplied, metadata download is completed.", (boolean)((MetadataFileSet)torrent.getMetadata().get()).isDone());
        Assert.assertTrue((String)"Torrent file set have several pieces as defined in metadata", (torrent.getFileSet().getPieceCount() > 0 ? 1 : 0) != 0);
    }
}

